package cn.com.duiba.sso.api.tool;

import cn.com.duiba.application.boot.api.ApplicationProperties;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.sso.api.common.interfaces.AppInterfaceAnalysisService;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.service.SsoApplicationService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;

/**
 *
 * @author liuyao
 * @date 2017/12/5
 * 本系统的Mate信息
 */
@Slf4j
public class SystemInfo{

    private static SsoApplicationService ssoSystemService;

    private static ApplicationProperties applicationProperties;

    /**
     * 获取本系统的信息
     */
    public static ApplicationDto getThisSystemInfo(){
        return ssoSystemService.getSystemByAlias(applicationProperties.getApplicationName());
    }

    /**
     * 获取本系统的Id
     */
    public static Long getThisSystemId(){
        ApplicationDto system = getThisSystemInfo();
        if(system==null){
            throw new SsoRunTimeException("没有检索到"+applicationProperties.getApplicationName()+"对应的系统配置");
        }
        return system.getId();
    }

    @Autowired
    public void setSsoSystemService(SsoApplicationService ssoSystemService) {
        SystemInfo.ssoSystemService = ssoSystemService;//NOSONAR
    }

    @Autowired
    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        SystemInfo.applicationProperties = applicationProperties;//NOSONAR
    }

    public static String getSystemAlias(){
        return applicationProperties.getApplicationName();
    }



}