package cn.com.duiba.sso.api.domain.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "duiba.sso")
public class SsoProperties {
    /**
     * 登录成功后默认的跳转地址，一般为首页地址
     */
    private String defaultRedirectUrl = "/";
    /**
     * sso服务的访问地址
     */
    private String ssoSystemUrl;

    /**
     * sso要拦截的url，配置多个地址用","分隔
     * 若没配置，就采用默认值/** 拦截所有
     */
    private String pathPatterns = "/**";

    /**
     * 排除的路径，sso不拦截
     */
    private String excludePathPatterns;

    public String getDefaultRedirectUrl() {
        return defaultRedirectUrl;
    }

    public void setDefaultRedirectUrl(String defaultRedirectUrl) {
        this.defaultRedirectUrl = defaultRedirectUrl;
    }

    public String getSsoSystemUrl() {
        return ssoSystemUrl;
    }

    public void setSsoSystemUrl(String ssoSystemUrl) {
        this.ssoSystemUrl = ssoSystemUrl;
    }

    public String getPathPatterns() {
        return pathPatterns;
    }

    public void setPathPatterns(String pathPatterns) {
        this.pathPatterns = pathPatterns;
    }

    public String getExcludePathPatterns() {
        return excludePathPatterns;
    }

    public void setExcludePathPatterns(String excludePathPatterns) {
        this.excludePathPatterns = excludePathPatterns;
    }
}

