package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.AdminInfoDto;

import java.util.List;
import java.util.Set;

/**
 * Created by liuyao on 2017/5/12.
 */
@SsoInterface(RemoteAdminService.class)
@AdvancedFeignClient
public interface RemoteAdminService {

    /**
     * 查询单个员工信息
     * @param id
     * @return
     * @throws BizException 员工已经离职
     */
    AdminDto findOneAdmin(Long id) throws BizException;

    /**
     * 根据邮箱获取管理员信息
     * @param email
     * @throws BizException 员工已经离职
     * @return
     */
    AdminDto findByEmail(String email) throws BizException;

    /**
     * 查询员工简要的信息，此方法可以查询所有的员工，包括离职
     * @param id
     * @return
     */
    AdminInfoDto findSimpleAdminInfo(Long id);

    /**
     * 按系统和角色名称检索管理员
     * @param systemId
     * @param roleName
     * @return
     */
    List<AdminDto> findAdminsByRoleName(Long systemId,String roleName);

    /**
     * 查出拥有权限所有管理员
     * @param systemId
     * @param powerIds
     * @return
     */
    List<AdminDto> findAdminsByPowerIds(Long systemId, Set<Long> powerIds);

    /**
     * 验证谷歌动态码
     * @param adminId
     * @param code
     * @return
     */
    Boolean googleCodeVerify(Long adminId,String code);

    /**
     * 批量查询管理员
     * @param ids
     * @return
     */
    List<AdminDto> batchFindAdminByIds(List<Long> ids);

    /**
     * 批量查询员工信息，包括离职
     * @param ids
     * @return
     */
    List<AdminInfoDto> batchFindAdminInfoByIds(List<Long> ids);

    /**
     * 根据角色ID查询所有的管理员
     * @param roleIds
     * @return
     */
    List<AdminDto> findAdminByRoleIds(List<Long> roleIds);

    /**
     * 根据姓名或者账号拼音去匹配员工列表
     * @param adminName
     * @return
     */
    List<AdminDto> findByNameLike(String adminName);

}
