package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.domain.dto.RoleDto;

import java.util.List;
import java.util.Set;

/**
 * Created by Administrator on 2017/7/4.
 */
@SsoInterface(RemotePermissionService.class)
@AdvancedFeignClient
public interface RemotePermissionService {

    /**
     * 获取一个用户在一个系统下所有的角色
     * @param systemId
     * @param adminId
     * @return
     */
    List<RoleDto> getAdminAllRoles(Long systemId,Long adminId);

    /**
     * 获取管理员在指定系统下的权限
     * @param systemId
     * @param adminId
     * @return
     */
    Set<Long> getPowerIdsBySystemIdAndAdminId(Long systemId,Long adminId);

    /**
     * 获取管理员权限配置的版本号
     * @param systemId
     * @param adminId
     * @return
     */
    Long getAdminPowerVersion(Long systemId,Long adminId);

    /**
     * 加载权限树
     * @param systemId
     * @return
     */
    List<PowerDto> loadPowerList(Long systemId);

    /**
     * 获取系统的权限树的版本号
     * @param systemId
     * @return
     */
    Long getSystemPowerVersion(Long systemId);

}
