package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.SystemDto;

import java.util.Map;
import java.util.Set;

/**
 * Created by liuyao on 2017/12/5.
 */
@SsoInterface(RemoteSystemService.class)
@AdvancedFeignClient
public interface RemoteSystemService {

    /**
     * 根据系统别名获取系统信息
     * @param appNameAlias
     * @return
     */
    SystemDto getSystemByAlias(String appNameAlias);

    /**
     * 提交版本号
     */
    void submitSsoVersion(Long systemId,String version);

    /**
     * 获取sso系统版本号
     * @param appNameAliasSet
     * @return （appNameAlias -> version）
     */
    Map<String,String> findSsoSystemVersionMap(Set<String> appNameAliasSet);

}
