define([
    "angular",
    "/ui/lib/angular/angular-ui-router.min.js",
    "/ui/lib/bootstrap/ui-bootstrap-tpls-0.14.3.min.js",
    "/ui/lib/sortable/angular-sortable.min.js",
    "/ui/lib/animate/animate.js",
    "/ui/configuration/ui-sso-configuration.js",

    "css!/ui/lib/bootstrap/bootstrap.min.css",
    "css!/ui/lib/font-awesome/font-awesome.min.css",
    "css!/ui/css/build.css"
],function (angular) {
    "use strict";

    const boot = angular.module("ui.boot",[
        "ui.sso",
        "ui.router",
        "ui.bootstrap",
        "ui.sortable",
        "ngAnimate-animate.css"
    ]);

    boot.config(Config);
    boot.run(Run);
    boot.service("pageService",PageService);
    boot.service("mumeService",MumeService);
    boot.factory("MessageInterceptor",MessageInterceptor);

    Config.$inject = ['$httpProvider','$stateProvider','$urlRouterProvider'];
    function Config($httpProvider,$stateProvider,$urlRouterProvider){
        $httpProvider.interceptors.push(MessageInterceptor);//打印错误日志
        $urlRouterProvider.otherwise("/index");
    }

    /** @ngInject **/
    function Run($rootScope,$http,$state,mumeService,SsoService){

        $rootScope.$state = $state;
        $rootScope.isCollapsed = true;

        $rootScope.mumeList = [];
        $rootScope.secondList = [];

        $rootScope.$on('$stateNotFound',function(event, toState, toParams, fromState, fromParams, options){
            if(toState.to==="index"){
                location.href = SsoService.getHomeUrl()+"/ui";
                return;
            }
            const state = mumeService.getStateUrl({state: toState.to, params: toState.toParams});
            const nav = mumeService.getNavByState(state);
            if(!!nav){
                location.href = nav.url;
            }else{
                alert("没有"+toState.to+"对应的state");
            }
        });


        /**
         * 如果存在子菜单，就默认选择子菜单的第一项
         */
        $rootScope.$on('$stateChangeSuccess', function(event, toState, toParams, fromState, fromParams, options){
            $rootScope.stateName = toState.name;
            if(toState.name==='index'){
                $rootScope.isCollapsed2 = false;
                $rootScope.secondList = [];
                return;
            }
            angular.forEach($rootScope.mumeList,function (nav) {
                if(nav.state===$rootScope.getFristState(toState.name)){
                    $rootScope.secondList = !!nav.child?nav.child:[];
                    $rootScope.isCollapsed2 = !!$rootScope.secondList.length;
                    $rootScope.isCollapsed = !$rootScope.isCollapsed2;
                }
            });
        });

        $rootScope.getStateName = function(){
            return angular.element(".product-nav-list .active .nav-title").html();
        };

        $rootScope.getStateUrl = mumeService.getStateUrl;

        $rootScope.goBack = function(){
            history.go(-1);
        };

        $rootScope.getFristState = function(){
            if(angular.isString($rootScope.stateName)){
                var stateList = $rootScope.stateName.split(".");
                return stateList[0];
            }else{
                return "";
            }
        };
    }

    MessageInterceptor.$inject=["$q","$injector"];
    function MessageInterceptor($q,$injector) {

        return {
            response: function (response) {
                var deferred = $q.defer();
                var data = response.data;
                if (data.hasOwnProperty("success") && !data.success) {
                    if(!!data.message){
                        console.log(data.message);
                    }
                    deferred.reject(response);
                } else {
                    deferred.resolve(response);
                }
                return deferred.promise;
            }
        };
    }

    /** @ngInject **/
    function MumeService($cacheFactory,$http,$rootScope) {

        var mumeCache = $cacheFactory('$$MumeCache');
        var indexUrl;

        $rootScope.$on("SYSTEM_SUCCESS",function(event,system){
            $http.get("/sso/ui/uiMume").success(function (data) {
                $rootScope.mumeList = data.mumes;
                $rootScope.secondList = [];

                angular.forEach(fengxiMume(data.mumes),function (item) {
                    mumeCache.put(getStateUrl(item),item);
                });
            });
        });

        function getNavByState(state) {
            return mumeCache.get(state);
        }


        function getStateUrl(nav){
            if(!nav) return "";
            var state = nav.state;
            if(!!nav.params && !!nav.params.length){
                state = state + "(" + angular.toJson(nav.params) + ")";
            }
            return state;
        }

        function fengxiMume(mumes) {
            var returnList = [];
            var list = [];

            var items = [].concat(mumes);
            angular.forEach(items, function (mume) {
                returnList.push(mume);
                if (!!mume.child && !!mume.child.length) {
                    list.push(mume);
                }
            });
            var nav;
            while (!list.length) {
                nav = list.shift();
                items = nav.child;
                angular.forEach(items, function (mume) {
                    returnList.add(mume);
                    if (!!mume.child && !!mume.child.length) {
                        list.push(mume);
                    }
                });
            }
            return returnList;
        }

        return {
            getStateUrl:getStateUrl,
            getNavByState:getNavByState
        }
    }



    function PageService(){
        this.pageType = null;
        this.pageIndex = 1;
        this.hasIndex = false;
        this.canload = true;
    }
    PageService.prototype.init = function(pageType){
        if(this.pageType===pageType && this.pageIndex !==1){
            this.hasIndex = true;
            return;
        }
        this.pageType = pageType;
        this.pageIndex = 1;
    };
    PageService.prototype.setIndex = function(index){
        if(this.hasIndex && index===1){
            this.hasIndex = false;
            this.canload = false;
            return;
        }
        this.pageIndex = index;
    };
    PageService.prototype.getIndex = function(){
        return this.pageIndex;
    };
    PageService.prototype.isCanLoad=function(){
        if(this.canload){
            return true;
        }else{
            this.canload = true;
            return false;
        }
    };
    return boot;
});