package cn.com.duiba.sso.ui;

import cn.com.duiba.sso.api.SsoAutoConfiguration;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import static org.springframework.web.bind.annotation.RequestMethod.GET;

@RestController
@Configuration
@ComponentScan("cn.com.duiba.sso.ui")
@AutoConfigureAfter(SsoAutoConfiguration.class)
@ConditionalOnProperty(name = "duiba.sso.ui.enabled", havingValue="true", matchIfMissing = false)
public class SsoUIConfiguration extends WebMvcConfigurerAdapter {

    @Autowired
    private SsoInterceptor ssoInterceptor;
    @Autowired
    private SsoUIResManager ssoUIResManager;

    @Value("classpath:ui/index.html")
    Resource indexHtml;

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/ui/**")
                .addResourceLocations("classpath:/ui/");

        ssoInterceptor.addExcludePath("/ui/**");

    }

    @RequestMapping(value = "/ui/index.html", method = GET)
    public ResponseEntity<?> serveIndex() throws IOException {
        ResponseEntity.BodyBuilder result = ResponseEntity.ok()
                .cacheControl(CacheControl.maxAge(1, TimeUnit.MINUTES))
                .contentType(MediaType.TEXT_HTML);
        return result.body(indexHtml);
    }

    @RequestMapping(value = {"/ui/","/ui"},method = GET)
    public ModelAndView forwardUiEndpoints() {
        return new ModelAndView("forward:/ui/index.html");
    }

    @RequestMapping(value = "/ui/main.js", method = GET)
    public ResponseEntity<?> mainJs() throws IOException {
        ResponseEntity.BodyBuilder result = ResponseEntity.ok()
                .cacheControl(CacheControl.maxAge(1, TimeUnit.MINUTES))
                .contentType(MediaType.parseMediaType("application/javascript"));
        return result.body(ssoUIResManager.getMainJs());
    }
}
