package cn.com.duiba.sso.ui;

import cn.com.duiba.sso.api.tool.TemplateUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.List;
import java.util.Map;

@Service
public class SsoUIResManager {

    @Value("classpath:temp/main.jsvm")
    Resource mainJs;

    private Map<String,String> jsMap = Maps.newConcurrentMap();

    public void regestModule(String name,String configuration){
        jsMap.put(name,configuration);
    }

    public String getMainJs() throws IOException {
        List<String> list = Lists.newArrayList();
        list.addAll(jsMap.keySet());
        String lists = JSONObject.toJSONString(list);
        String maps =  JSONObject.toJSONString(jsMap);

        JSONObject model = new JSONObject();
        model.put("rootMoudles",lists);
        model.put("rootMoudleMap",maps);

        CharSource source = Resources.asCharSource(mainJs.getURL(), Charsets.UTF_8);
        return TemplateUtils.replaceArgs(source.read(),model);
    }

}
