/**
 * ui.model.ext 是构建在 ui.bootstrap.model之上的封装
 * 详见 http://angular-ui.github.io/bootstrap/#!#modal
 */
define([
    "angular",
    "/ui/lib/bootstrap/ui-bootstrap-tpls-0.14.3.min.js",

    "css!./ui-model.css"
],function (angular) {

    const model = angular.module("ui.model", ["ui.bootstrap"]);
    model.run(Run);
    model.service("UiModel",UiModel);

    /** @ngInject **/
    function Run($templateRequest){
        //预加载消息html模板
        $templateRequest("/ui/directive/model/loading.html");
        $templateRequest("/ui/directive/model/message.html");
        $templateRequest("/ui/directive/model/prompt.html");
    }

    /** @ngInject **/
    function UiModel($uibModal,$rootScope){

        /**
         * 消息提示
         * @param message 信息
         * @param title 标题
         * @param config 标题
         * @returns promise
         */
        function alert(message,title,config){
            return confirm(message,title,angular.extend({},config,{showCancel:false}));
        }

        /**
         * 消息确认
         * @param message
         * @param title
         * @param config
         * {showCancel:true}
         * @returns promise
         */
        function confirm(message,title,config) {
            return prompt(message,title,angular.extend({showInput:false},config))
        }

        /**
         * 带输入框的消息确认
         * @param message
         * @param title
         * @param config default @see DEFAULT_PROMPT_CONFIG
         * @returns promise
         */
        function prompt(message,title,config){
            title = !!title?title:"提示";
            config = !!config?config:{};
            const promptInstance = $uibModal.open({
                size:!!config.size?config.size:"sm",
                animation: true,
                templateUrl:'/ui/directive/model/prompt.html',
                controller: PromptController,
                backdrop:'static',
                windowClass:"uiPrompt",
                resolve:{
                    $promptConfig:function(){
                        return angular.extend({},DEFAULT_PROMPT_CONFIG,config,{message:message,title:title});
                    }
                }
            });
            return promptInstance.result;
        }

        var MESSAGE_SCOPE;
        const MESSAGE_BASE_CONFIG = {
            message:"",
            type:"success",
            timeout:2000
        };

        function message(message,type,timeout){
            !MESSAGE_SCOPE && InitMessage();
            const config = {};
            !!message && (config.message = message);
            !!type && (config.type = type);
            !!timeout && (config.timeout = timeout);
            type==="danger" && (config.timeout = 100000000);
            MESSAGE_SCOPE.push(config);
        }

        function InitMessage() {

            if(!!MESSAGE_SCOPE){
                return MESSAGE_SCOPE;
            }
            MESSAGE_SCOPE = $rootScope.$new();
            MESSAGE_SCOPE.messages = [];
            MESSAGE_SCOPE.push = function(messageConfig){
                if(!messageConfig.message){
                    return;
                }
                MESSAGE_SCOPE.messages.push(angular.extend({},MESSAGE_BASE_CONFIG,messageConfig));
            };


            const messageInstance = $uibModal.open({
                size:"md",
                animation: true,
                templateUrl:'/ui/directive/model/message.html',
                backdrop:true,
                controller: MessageController,
                windowClass:"uiMessage",
                scope:MESSAGE_SCOPE
            });
            messageInstance.result.then(function () {
                MESSAGE_SCOPE.$destroy();
                MESSAGE_SCOPE = undefined;
            },function(){
                MESSAGE_SCOPE.$destroy();
                MESSAGE_SCOPE = undefined;
            });
            return MESSAGE_SCOPE;
        }

        function loading(message){
            const LOADING_SCOPE = $rootScope.$new();
            LOADING_SCOPE.message = message;
            const instance = $uibModal.open({
                size:"sm",
                animation: true,
                templateUrl:'/ui/directive/model/loading.html',
                backdrop:'static',
                windowClass:"uiLoading",
                scope:LOADING_SCOPE
            });
            return new LoadingController(LOADING_SCOPE,instance);
        }

        return {
            alert:alert,
            confirm:confirm,
            prompt:prompt,
            loading:loading,
            message:message
        }
    }

    function LoadingController(scope,instance){
        this.scope = scope;
        this.instance = instance;
    }

    LoadingController.prototype.updateMessage=function(message){
        this.scope.message = message;
        this.scope.$digest();
    };

    LoadingController.prototype.close=function(){
        this.instance.close();
    };


    const DEFAULT_PROMPT_CONFIG = {
        message:"",
        title:"",
        showCancel:true,
        showInput:true,
        promptInputInit:"",
        promptPlaceholder:"",
        type:"prompt",

        submitBtn:"确认",
        submitBtnClass:'primary',
        cancelBtn:"取消"
    };

    /** @ngInject **/
    function PromptController($promptConfig,$scope,$uibModalInstance){

        $scope.input = $promptConfig.promptInputInit;

        $scope.$promptConfig = $promptConfig;

        $scope.submit = function(){
            const input = $promptConfig.showInput?$scope.input:undefined;
            $uibModalInstance.close(input);
        };
        $scope.cancel = function(){
            $promptConfig.showCancel && $uibModalInstance.dismiss();
        }
    }

    /** @ngInject **/
    function MessageController($scope,$uibModalInstance) {

        $scope.closeAlert = function(index) {
            $scope.messages.splice(index, 1);
            if(!$scope.messages.length){
                $uibModalInstance.close();
            }
        };

        $scope.getClass = function(type){
            const key = "alert-" + type;
            return {"alert":true,key:true};
        }
    }



    return model;
});


