/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.ui;

import cn.com.duiba.sso.api.SsoAutoConfiguration;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.ui.SsoUIProperties;
import cn.com.duiba.sso.ui.SsoUIResManager;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@RestController
@Configuration
@ComponentScan(value={"cn.com.duiba.sso.ui"})
@AutoConfigureAfter(value={SsoAutoConfiguration.class})
@EnableConfigurationProperties(value={SsoUIProperties.class})
@ConditionalOnProperty(name={"duiba.sso.ui.enabled"}, havingValue="true", matchIfMissing=false)
public class SsoUIConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    private SsoInterceptor ssoInterceptor;
    @Autowired
    private SsoUIResManager ssoUIResManager;
    @Value(value="classpath:ui/index.html")
    Resource indexHtml;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/ui/**"}).addResourceLocations(new String[]{"classpath:/ui/"});
        this.ssoInterceptor.addExcludePath(new String[]{"/ui/**"});
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui/index.html"}, method={RequestMethod.GET})
    public ResponseEntity<?> serveIndex() throws IOException {
        ResponseEntity.BodyBuilder result = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.MINUTES))).contentType(MediaType.TEXT_HTML);
        return result.body((Object)this.indexHtml);
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui/", "/ui"}, method={RequestMethod.GET})
    public ModelAndView forwardUiEndpoints() {
        return new ModelAndView("forward:/ui/index.html");
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui/main.js"}, method={RequestMethod.GET})
    public ResponseEntity<?> mainJs() throws IOException {
        ResponseEntity.BodyBuilder result = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.MINUTES))).contentType(MediaType.parseMediaType((String)"application/javascript"));
        return result.body((Object)this.ssoUIResManager.getMainJs());
    }
}

