/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.ui;

import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.service.power.PowerTreeCache;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duiba.sso.ui.SsoUIMume;
import cn.com.duiba.sso.ui.SsoUIProperties;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sso/ui"})
public class SsoUIController {
    private static final String UI_SYSTEM_NAME = "zt-ui-boot";
    @Autowired
    private PowerTreeService powerTreeService;
    @Autowired
    private SsoSystemService ssoSystemService;
    @Autowired
    private SsoUIProperties ssoUIProperties;

    @CanAccess
    @RequestMapping(value={"/uiMume"})
    public JsonRender uiMume() {
        SystemDto system = this.ssoSystemService.getSystemByAlias(UI_SYSTEM_NAME);
        PowerTreeCache cache = this.powerTreeService.getPowerTreeCache(system.getId());
        try {
            SsoUIMumeTransform transform = new SsoUIMumeTransform();
            transform.setCache(cache);
            List mumes = cache.getPowerTree((Function)transform);
            JsonRender render = JsonRender.successResult();
            render.put("mumes", (Object)mumes);
            return render;
        }
        catch (Exception e) {
            return JsonRender.failResult((Throwable)e);
        }
    }

    private class SsoUIMumeTransform
    implements Function<PowerDto, SsoUIMume> {
        private PowerTreeCache cache;
        private Joiner joiner = Joiner.on((String)".").skipNulls();

        private SsoUIMumeTransform() {
        }

        @Override
        public SsoUIMume apply(PowerDto powerDto) {
            if (StringUtils.isBlank((String)powerDto.getJson())) {
                throw new SsoRunTimeException("\u83dc\u5355\u9879\uff1a" + powerDto.getName() + "\u914d\u7f6e\u5f02\u5e38");
            }
            SsoUIMume mume = new SsoUIMume();
            mume.setId(powerDto.getId());
            mume.setParentId(powerDto.getParentId());
            mume.setName(powerDto.getName());
            JSONObject json = JSONObject.parseObject((String)powerDto.getJson());
            List powerLinks = this.cache.getPowerWay(powerDto.getId());
            List stateList = powerLinks.stream().map(power -> {
                JSONObject item = JSONObject.parseObject((String)power.getJson());
                return item.getString("state");
            }).collect(Collectors.toList());
            mume.setUrl(json.getString("url"));
            mume.setState(this.joiner.join(stateList));
            if (json.containsKey((Object)"params")) {
                mume.setParams(json.getJSONObject("params"));
            }
            if (json.containsKey((Object)"icon")) {
                mume.setIcon(json.getString("icon"));
            }
            if (json.containsKey((Object)"system")) {
                SystemDto system = SsoUIController.this.ssoSystemService.getSystemByAlias(json.getString("system"));
                mume.setSystemId(system.getId());
            }
            if (json.containsKey((Object)"keys")) {
                mume.setSsoRes(json.getString("keys"));
            }
            return mume;
        }

        public PowerTreeCache getCache() {
            return this.cache;
        }

        public void setCache(PowerTreeCache cache) {
            this.cache = cache;
        }
    }
}

