package cn.com.duiba.sso.ui;

import cn.com.duiba.sso.api.SsoAutoConfiguration;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import cn.com.duiba.sso.ui.mume.FileMumeLoader;
import cn.com.duiba.sso.ui.mume.MumeLoader;
import cn.com.duiba.sso.ui.mume.SystemResourceMumeLoader;
import cn.com.duiba.sso.ui.resource.SsoUIController;
import cn.com.duiba.sso.ui.resource.SsoUIResManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@RestController
@Configuration
@AutoConfigureAfter(SsoAutoConfiguration.class)
@EnableConfigurationProperties(SsoUIProperties.class)
@ConditionalOnProperty(name = "duiba.sso.ui.enabled", havingValue="true", matchIfMissing = false)
public class SsoUIConfiguration extends WebMvcConfigurerAdapter {

    @Autowired
    private SsoInterceptor ssoInterceptor;
    @Autowired
    private SsoUIProperties ssoUIProperties;

    @Bean
    @ConditionalOnMissingBean
    public MumeLoader mumeLoader(){
        switch (ssoUIProperties.getMenuType()){
            case FILE:return new FileMumeLoader();
            case SSO_RESOURCE:
            default: return new SystemResourceMumeLoader();
        }
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/ui/**")
                .addResourceLocations("classpath:/ui/");
        ssoInterceptor.addExcludePath("/ui/**");
    }

    @Bean
    public SsoUIResManager ssoUIResManager(){
        return new SsoUIResManager();
    }

    @Bean
    public SsoUIController ssoUIController(){
        return new SsoUIController();
    }



}
