package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duiba.sso.ui.mume.MumeLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import static org.springframework.web.bind.annotation.RequestMethod.GET;

@Controller
public class SsoUIController {

    @Autowired
    private MumeLoader mumeLoader;
    @Autowired
    private SsoUIResManager ssoUIResManager;

    @Value("classpath:ui/index.html")
    Resource indexHtml;

    @CanAccess
    @ResponseBody
    @RequestMapping(value = "/sso/ui/uiMume",method = RequestMethod.GET)
    public JsonRender uiMume(){

        try{
            JsonRender render = JsonRender.successResult();
            render.put("mumes",mumeLoader.loadUIMume());
            render.put("webTitle",ssoUIResManager.getWebTitle());
            return render;
        }catch (Exception e){
            return JsonRender.failResult(e);
        }
    }

    @AuthCanAccess
    @RequestMapping(value = "/ui/index.html", method = GET)
    public ResponseEntity serveIndex(){
        ResponseEntity.BodyBuilder result = ResponseEntity.ok()
                .cacheControl(CacheControl.maxAge(1, TimeUnit.MINUTES))
                .contentType(MediaType.TEXT_HTML);
        return result.body(indexHtml);
    }

    @AuthCanAccess
    @RequestMapping(value = {"/ui/","/ui"},method = GET)
    public ModelAndView forwardUiEndpoints() {
        return new ModelAndView("forward:/ui/index.html");
    }

    @AuthCanAccess
    @RequestMapping(value = "/ui/main.js", method = GET)
    public ResponseEntity mainJs() throws IOException {
        ResponseEntity.BodyBuilder result = ResponseEntity.ok()
                .cacheControl(CacheControl.maxAge(1, TimeUnit.MINUTES))
                .contentType(MediaType.parseMediaType("application/javascript"));
        return result.body(ssoUIResManager.getMainJs());
    }



}
