/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duiba.sso.ui.mume.MumeLoader;
import cn.com.duiba.sso.ui.resource.SsoUIResManager;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SsoUIController {
    @Autowired
    private MumeLoader mumeLoader;
    @Autowired
    private SsoUIResManager ssoUIResManager;
    @Value(value="classpath:ui/index.html")
    Resource indexHtml;

    @CanAccess
    @ResponseBody
    @RequestMapping(value={"/sso/ui/uiMume"}, method={RequestMethod.GET})
    public JsonRender uiMume() {
        try {
            JsonRender render = JsonRender.successResult();
            render.put("mumes", this.mumeLoader.loadUIMume());
            render.put("webTitle", (Object)this.ssoUIResManager.getWebTitle());
            return render;
        }
        catch (Exception e) {
            return JsonRender.failResult((Throwable)e);
        }
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui/index.html"}, method={RequestMethod.GET})
    public ResponseEntity serveIndex() {
        ResponseEntity.BodyBuilder result = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.MINUTES))).contentType(MediaType.TEXT_HTML);
        return result.body((Object)this.indexHtml);
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui/", "/ui"}, method={RequestMethod.GET})
    public ModelAndView forwardUiEndpoints() {
        return new ModelAndView("forward:/ui/index.html");
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui/main.js"}, method={RequestMethod.GET})
    public ResponseEntity mainJs() throws IOException {
        ResponseEntity.BodyBuilder result = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.MINUTES))).contentType(MediaType.parseMediaType((String)"application/javascript"));
        return result.body((Object)this.ssoUIResManager.getMainJs());
    }
}

