define([
    "angular",
    "/ui/lib/angular/function.js",
    "/ui/lib/angular/angular-ui-router.min.js",
    "/ui/lib/angular/angular-sanitize.min.js",
    "/ui/lib/bootstrap/ui-bootstrap-tpls-0.14.3.min.js",
    "/ui/lib/animate/animate.js",
    "/ui/configuration/ui-sso-configuration.js",
    "/ui/directive/ui-directive-configuration.js",

    "css!/ui/lib/bootstrap/bootstrap.min.css",
    "css!/ui/lib/font-awesome/font-awesome.min.css",
    "css!/ui/style/build.css"
],function (angular) {
    "use strict";

    const boot = angular.module("ui.boot",[
        "ui.sso",
        "ui.router",
        "ngSanitize",
        "ui.directive.ext",
        "ngAnimate-animate.css"
    ]);

    boot.config(Config);
    boot.run(Run);
    boot.service("mumeService",MumeService);


    /** @ngInject **/
    function Config($httpProvider,$stateProvider,$urlRouterProvider){
        $urlRouterProvider.otherwise("/index");
    }

    /** @ngInject **/
    function Run($rootScope,$http,$state,mumeService,SsoService){

        $rootScope.$state = $state;
        $rootScope.isCollapsed = true;

        $rootScope.mumeList = [];
        $rootScope.secondList = [];

        $rootScope.$on('$stateNotFound',function(event, toState, toParams, fromState, fromParams, options){
            if(toState.to==="index"){
                location.href = SsoService.getHomeUrl()+"/ui";
                return;
            }
            const state = mumeService.getStateUrl({state: toState.to, params: toState.toParams});
            const nav = mumeService.getNavByState(state);
            if(!!nav){
                location.href = nav.url;
            }else{
                alert("没有"+toState.to+"对应的state");
            }
        });


        /**
         * 如果存在子菜单，就默认选择子菜单的第一项
         */
        $rootScope.$on('$stateChangeSuccess', function(event, toState, toParams, fromState, fromParams, options){
            $rootScope.stateName = toState.name;
            if(toState.name==='index'){
                $rootScope.isCollapsed2 = false;
                $rootScope.secondList = [];
                return;
            }
            mumeService.flushSocoundMume(toState.name);
        });

        $rootScope.getStateName = function(){
            return angular.element(".sidebar-trans .active .nav-title").html();
        };

        $rootScope.getStateUrl = mumeService.getStateUrl;

        $rootScope.goBack = function(){
            history.go(-1);
        };

        $rootScope.getFristState = function(){
            if(angular.isString($rootScope.stateName)){
                var stateList = $rootScope.stateName.split(".");
                return stateList[0];
            }else{
                return "";
            }
        };
    }

    /** @ngInject **/
    function MumeService($cacheFactory,$http,$rootScope,$state) {

        var mumeCache = $cacheFactory('$$MumeCache');

        $rootScope.$on("SYSTEM_SUCCESS",function(event,system){
            $http.get("/sso/ui/uiMume").success(function (data) {
                $rootScope.mumeList = data.mumes;
                $rootScope.webTitle = data.webTitle;
                $rootScope.secondList = [];
                flushSocoundMume($state.$current.name);
                angular.forEach(fengxiMume(data.mumes),function (item) {
                    mumeCache.put(getStateUrl(item),item);
                });
            });
        });

        function flushSocoundMume(stateName) {
            angular.forEach($rootScope.mumeList,function (nav) {
                if(nav.state===$rootScope.getFristState(stateName)){
                    $rootScope.secondList = !!nav.child?nav.child:[];
                    $rootScope.isCollapsed2 = !!$rootScope.secondList.length;
                    $rootScope.isCollapsed = !$rootScope.isCollapsed2;
                }
            });
        }

        function getNavByState(state) {
            return mumeCache.get(state);
        }

        function getStateUrl(nav){
            if(!nav) return "";
            var state = nav.state;
            if(!!nav.params && !!nav.params.length){
                state = state + "(" + angular.toJson(nav.params) + ")";
            }
            return state;
        }

        function fengxiMume(mumes) {
            var returnList = [];
            var list = [];

            var items = [].concat(mumes);
            angular.forEach(items, function (mume) {
                returnList.push(mume);
                if (!!mume.child && !!mume.child.length) {
                    list.push(mume);
                }
            });
            var nav;
            while (!!list.length) {
                nav = list.shift();
                items = nav.child;
                angular.forEach(items, function (mume) {
                    returnList.push(mume);
                    if (!!mume.child && !!mume.child.length) {
                        list.push(mume);
                    }
                });
            }
            return returnList;
        }

        return {
            getStateUrl:getStateUrl,
            getNavByState:getNavByState,
            flushSocoundMume:flushSocoundMume
        }
    }

    boot.filter('propsFilter', function() {
        return function(items, props) {
            var out = [];

            if (angular.isArray(items)) {
                var keys = Object.keys(props);

                items.forEach(function(item) {
                    var itemMatches = false;

                    for (var i = 0; i < keys.length; i++) {
                        var prop = keys[i];
                        var text = props[prop].toLowerCase();
                        if (item[prop].toString().toLowerCase().indexOf(text) !== -1) {
                            itemMatches = true;
                            break;
                        }
                    }

                    if (itemMatches) {
                        out.push(item);
                    }
                });
            } else {
                // Let the output be the input untouched
                out = items;
            }

            return out;
        };
    });

    return boot;
});