/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.ui;

import cn.com.duiba.sso.api.SsoAutoConfiguration;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import cn.com.duiba.sso.ui.SsoUIProperties;
import cn.com.duiba.sso.ui.mume.FileMumeLoader;
import cn.com.duiba.sso.ui.mume.MumeLoader;
import cn.com.duiba.sso.ui.mume.SystemResourceMumeLoader;
import cn.com.duiba.sso.ui.resource.SsoUIController;
import cn.com.duiba.sso.ui.resource.SsoUIResManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@RestController
@Configuration
@AutoConfigureAfter(value={SsoAutoConfiguration.class})
@EnableConfigurationProperties(value={SsoUIProperties.class})
@ConditionalOnProperty(name={"duiba.sso.ui.enabled"}, havingValue="true", matchIfMissing=false)
public class SsoUIConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    private SsoInterceptor ssoInterceptor;
    @Autowired
    private SsoUIProperties ssoUIProperties;

    @Bean
    @ConditionalOnMissingBean
    public MumeLoader mumeLoader() {
        switch (this.ssoUIProperties.getMenuType()) {
            case FILE: {
                return new FileMumeLoader();
            }
        }
        return new SystemResourceMumeLoader();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/ui/**"}).addResourceLocations(new String[]{"classpath:/ui/"});
        this.ssoInterceptor.addExcludePath(new String[]{"/ui/**"});
    }

    @Bean
    public SsoUIResManager ssoUIResManager() {
        return new SsoUIResManager();
    }

    @Bean
    public SsoUIController ssoUIController() {
        return new SsoUIController();
    }
}

