define(["angular","ui.boot"],function (angular) {

    const sso = angular.module("ui.sso", []);

    const LOGIN_LOSE_EVENT = "LOGIN_LOSE_EVENT";//登录失效事件
    const AUTH_FLUSH_EVENT = "AUTH_FLUSH_EVENT";//权限更新事件
    const SYSTEM_SUCCESS = "SYSTEM_SUCCESS";//系统信息加载成功事件
    const CURRENT_PATH = "CURRENT_PATH";
    const AUTH_CACHE_NAME = "$$authCache";

    sso.run(SsoRun);

    sso.config(Config);
    sso.factory("SsoInterceptor",SsoInterceptor);
    sso.service("SsoService",SsoService);
    sso.controller("SsoResController",SsoResController);
    sso.directive('ssoRes', SsoRes);

    /** @ngInject **/
    function Config($httpProvider){
        $httpProvider.interceptors.push("SsoInterceptor");
    }

    /** @ngInject **/
    function SsoRun(SsoService,$rootScope,$location){

        SsoService.adminInfo().then(function(admin){//检测登录
            $rootScope.adminId = admin.adminId;
            $rootScope.adminName = admin.adminName;
        });

        $rootScope.$on(LOGIN_LOSE_EVENT,function () {
            sessionStorage.setItem(CURRENT_PATH,$location.path());
            window.location.reload();
        });//监听登录失效

        $rootScope.outLogin=outLogin;

        function outLogin(){
            SsoService.outLogin().then(function(){
                $rootScope.$broadcast(LOGIN_LOSE_EVENT);
            });
        }

        const path = sessionStorage.getItem(CURRENT_PATH);
        if(!!path){
            sessionStorage.removeItem(CURRENT_PATH);
            $location.url(path)
        }
    }

    function SsoRes() {
        return {
            priority: 0,
            scope: {
                ssoRes:'@'
            },
            restrict: 'A', // E = Element, A = Attribute, C = Class, M = Comment
            controller:"SsoResController",
            replace: true
        }
    }

    SsoResController.$inject = ["$scope","$element","SsoService"];
    function SsoResController($scope,$element,SsoService){
        $element.addClass("ng-hide");

        $scope.$on("AUTH_FLUSH_EVENT",function () {
            SelectSsoRes();
        });
        SelectSsoRes();

        function SelectSsoRes() {
            if(SsoService.getAuthSet().has($scope.ssoRes)){
                $element.removeClass("ng-hide");
            }else{
                $element.addClass("ng-hide");
            }
        }
    }

    SsoInterceptor.$inject=["$q","$injector","$cookies"];
    function SsoInterceptor($q,$injector,$cookies){

        GoLogin.$inject = ["$rootScope"];
        function GoLogin($rootScope){
            $rootScope.$broadcast(LOGIN_LOSE_EVENT);
        }

        /** @ngInject **/
        function ShowMessage(UiModel){
            UiModel.message(this,"danger");
        }

        return {
            request:function(config) {
                var csrfToken = $cookies.get("csrf_token");
                !!csrfToken && (config.headers['X-Csrf-Token'] = csrfToken);
                return config;
            },
            response: function(response) {
                const deferred = $q.defer();
                const data = response.data;
                if(!data.success && !!data.notLogin){
                    $injector.invoke(GoLogin);
                    deferred.reject(response);
                    return deferred.promise;
                }
                if (data.hasOwnProperty("success") && !data.success) {
                    if(!!data.message){
                        $injector.invoke(ShowMessage,data.message);
                    }else{
                        $injector.invoke(ShowMessage,"请求失败");
                    }
                    deferred.reject(response);
                } else {
                    deferred.resolve(response);
                }
                return deferred.promise;

            }
        };
    }

    /** @ngInject **/
    function SsoService($http,$q,$cacheFactory,$interval,$rootScope){

        const AUTH_CACHE = $cacheFactory(AUTH_CACHE_NAME);
        const WHILE_AUTH = ["deploy", "app"];
        var ssoHomeUrl;
        var system;

        loudAuthSet();
        systemInfo();

        function adminInfo(){
            const defer = $q.defer();
            $http.get("/sso/admin/adminInfo").success(function(data){
                defer.resolve({adminId:data.adminId,adminName:data.adminName});
            });
            return defer.promise;
        }

        function systemInfo() {
            const defer = $q.defer();
            $http.get("/sso/systemInfo").success(function(data){
                if(data.success){
                    ssoHomeUrl = data.ssoHomeURL;
                    system = data.system;
                    $rootScope.$systemName = data.system.appNameAlias;
                    $rootScope.appName = data.system.appName;
                    $rootScope.environment = data.environment;
                    $rootScope.$broadcast(SYSTEM_SUCCESS,data.system);
                }
            });
            return defer.promise;
        }

        function getAuthSet(){
            const authSet = AUTH_CACHE.get("$$SsoAuthSet");
            if(!authSet){
                return new Set();
            }else{
                return authSet;
            }
        }

        function loudAuthSet() {
            var defer = $q.defer();
            $http.get("/auth/getAuthList").success(function(data){
                var authSet = new Set(data.authList);
                AUTH_CACHE.put("$$SsoAuthSet",authSet);
                angular.forEach(WHILE_AUTH,function(item){
                    authSet.add(item);
                });
                AUTH_CACHE.put("$$SsoAuthVersion",data.version);
                $rootScope.$broadcast(AUTH_FLUSH_EVENT);
                defer.resolve(authSet);
            });
            return defer.promise;
        }

        function getAuthVersion(){
            var defer = $q.defer();
            $http.get("/auth/getAuthVersion").success(function(data){
                defer.resolve(data.version);
            });
            return defer.promise;
        }

        function outLogin(){
            const defer = $q.defer();
            $http.get("/sso/outLogin").success(function(data){
                defer.resolve(data.version);
            });
            return defer.promise;
        }

        function getHomeUrl(){
            return ssoHomeUrl;
        }

        function searchAdminLikeNameOrAccount(search){
            if(!search){
                return $q.when([])
            }
            const defer = $q.defer();
            $http.get("/sso/admin/searchAdminLikeNameOrAccount",{params:{search:search}}).success(function(data){
                defer.resolve(data.adminList);
            });
            return defer.promise;
        }


        return {
            adminInfo:adminInfo,
            getAuthSet:getAuthSet,
            getAuthVersion:getAuthVersion,
            outLogin:outLogin,
            getHomeUrl:getHomeUrl,
            searchAdminLikeNameOrAccount:searchAdminLikeNameOrAccount
        }
    }

    return sso;
});