define([
    "angular", "ui.boot",
    "/ui/lib/angular/ng-file-upload.min.js"

], function (angular) {

    /**
     * 可监控进度的下载，上传，以及上传后的文件处理
     */
    const uiFile = angular.module("ui.file", ["ngFileUpload"]);
    uiFile.service("UiFileService", UiFileService);
    uiFile.controller("ExportFileController",ExportFileController);

    /** @ngInject **/
    function UiFileService($http,$q,$interval,$uibModal) {

        function exportFile(url,params){
            var modalInstance = $uibModal.open({
                size:'md',
                animation: true,
                templateUrl:'/ui/directive/file/exportFile.html',
                controller: 'ExportFileController',
                controllerAs:'p',
                backdrop:"static",
                resolve:{
                    url:function(){
                        return url;
                    },
                    params:function(){
                        return params;
                    }
                }
            });
            return modalInstance.result;
        }

        /**
         * @param $scope 提交任务的当前 $scope
         * @param taskId
         * @returns promise{{url},{},{count,successCount}}
         */
        function findTaskStatue($scope,taskId){
            const defer = $q.defer();
            const task = $interval(function(){
                $http.get('/sso/export/taskInfo', {params: {taskId: taskId}}).success(function(res){
                    let data = res.info;
                    defer.notify({
                        count:data.count,
                        successCount:data.successCount,
                        fileName:data.fileName
                    });
                    if (data.success) {
                        $interval.cancel(task);
                        defer.resolve({url:data.url});
                    }
                });
            },800);
            $scope.$on('$destroy', function() {
                $interval.cancel(task);
            });
            return defer.promise;
        }

        return {
            exportFile:exportFile,
            findTaskStatue:findTaskStatue,
        }

    }

    //url:导出文件的请求地址，params：请求参数
    /** @ngInject **/
    function ExportFileController($scope,url,params,UiModel,UiFileService,$http,$uibModalInstance) {

        $scope.progress=0;
        $scope.progressw=0;
        $scope.total=0;
        $scope.filename="";
        $scope.disabled=true;

        $scope.url = "";

        $scope.cancel = function(){
            $uibModalInstance.dismiss();
        };

        if (localStorage.exportStatus) {
            UiModel.message("你还有未处理的导出任务","info");
            paramsFun();
        } else {
            fileExport();
        }

        function paramsFun() {
            let exportStatus = JSON.parse(localStorage.exportStatus);
            $scope.total = exportStatus.count;
            findTaskStatue(exportStatus.taskId);
        }
        
        function findTaskStatue(taskId) {
            UiFileService.findTaskStatue($scope,taskId).then(function (result) {
                $scope.url = result.url;
                $scope.disabled=false;
                localStorage.removeItem("exportStatus");
            },angular.noop,function (data) {
                $scope.total = data.count;
                $scope.progress = data.successCount;
                $scope.progressw = 'width:' + (data.successCount / $scope.total * 100) + '%';
                $scope.fileName = data.fileName;
            });
        }

        function fileExport(){
            $http.post(url,params).success(function(res){
                if (res && res.taskId) {
                    if(!res.count){
                        UiModel.message("没有检索到可以导出的条目","warning");
                        $uibModalInstance.dismiss();
                        return
                    }
                    localStorage.exportStatus = JSON.stringify(res);
                    paramsFun();
                }
            }).error(function(message){
                $uibModalInstance.dismiss(message);
            });
        }
    }

    function UploadFileService() {

    }

    return uiFile;
});