package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.sso.api.service.system.EnvironmentDecisionMaker;
import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import cn.com.duiba.sso.api.tool.TemplateUtils;
import cn.com.duiba.sso.ui.mume.MumeLoader;
import cn.com.duiba.sso.ui.mume.SsoUIMume;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Slf4j
@Service
public class SsoUIResManager {

    @Value("classpath:temp/main.jsvm")
    private org.springframework.core.io.Resource mainJs;
    @Value("classpath:temp/index.html")
    private org.springframework.core.io.Resource mainHomeIndex;
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private MumeLoader mumeLoader;
    @Resource
    private EnvironmentDecisionMaker environmentDecisionMaker;
    @Resource
    private RemoteSystemService remoteSystemService;

    private Map<String,String> jsMap = Maps.newConcurrentMap();

    private String webTitle = "服务综合治理平台";

    public void regestModule(String name,String configuration){
        jsMap.put(name,configuration);
    }

    public void setWebTitle(String webTitle) {
        this.webTitle = webTitle;
    }

    protected String indexHtml() throws IOException {

        JSONObject model = new JSONObject();
        model.put("rootPath",ssoProperties.getRootPath());
        model.put("webTitle",webTitle);

        EnvironmentEnum environmentEnum = environmentDecisionMaker.getEnvironmentEnum();

        model.put("environment",environmentEnum.getName());

        List<SsoUIMume> ssoUIMume =  mumeLoader.loadUIMume();
        fixMumeUrl(ssoUIMume);

        model.put("mumeList", JSONArray.toJSONString(ssoUIMume));



        CharSource source = Resources.asCharSource(mainHomeIndex.getURL(), Charsets.UTF_8);
        return TemplateUtils.replaceArgs(source.read(),model);
    }


    protected String getMainJs() throws IOException {
        List<String> list = Lists.newArrayList();
        list.addAll(jsMap.keySet());
        String lists = JSONObject.toJSONString(list);
        String maps =  JSONObject.toJSONString(jsMap);

        JSONObject model = new JSONObject();
        model.put("rootMoudles",lists);
        model.put("rootMoudleMap",maps);


        CharSource source = Resources.asCharSource(mainJs.getURL(), Charsets.UTF_8);
        return TemplateUtils.replaceArgs(source.read(),model);
    }

    private void fixMumeUrl(List<SsoUIMume> ssoUIMumes){

        List<SsoUIMume> mumes = traversal(ssoUIMumes);
        Set<String> appNames = Sets.newHashSet();


        List<SsoUIMume> canFixList = Lists.newArrayList();
        for(SsoUIMume mume:mumes){
            if(StringUtils.isNotBlank(mume.getSystem())){
                appNames.add(mume.getSystem());
                canFixList.add(mume);
            }
        }

        EnvironmentEnum environmentEnum = environmentDecisionMaker.getEnvironmentEnum();
        Map<String,String> homeUrlMap = remoteSystemService.findAppHomeUrlMap(environmentEnum.getName(),appNames);

        for(SsoUIMume mume:canFixList){
            try{
                if(!homeUrlMap.containsKey(mume.getSystem())){
                    continue;
                }
                String homeUrl = homeUrlMap.get(mume.getSystem());

                if(StringUtils.startsWith(mume.getUrl(),"/")){
                    mume.setUrl(homeUrl+mume.getUrl());
                }
                if(StringUtils.startsWith(mume.getUrl(),"http")){
                    String url = mume.getUrl();
                    URL url1 = new URL(homeUrl);
                    URL url2 = new URL(mume.getUrl());

                    url = url.replace(url2.getAuthority(),url1.getAuthority());
                    mume.setUrl(url);
                }
            }catch (Exception e){
                log.debug("url:"+mume.getUrl()+"解析失败",e);
            }
        }
    }

    private List<SsoUIMume> traversal(List<SsoUIMume> ssoUIMumes){
        List<SsoUIMume> returnList = Lists.newArrayList();
        for(SsoUIMume mume:ssoUIMumes){
            returnList.add(mume);
            if(mume.getChild()!=null && !mume.getChild().isEmpty()){
                returnList.addAll(traversal(mume.getChild()));
            }
        }
        return returnList;
    }



}
