package cn.com.duiba.sso.ui.resource;


import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.enums.AdminApplicationRelation;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;

@RestController
@RequestMapping(value = "${duiba.sso.root-path:'/sso'}/uiboot")
public class UiBootDataController {

    @Resource
    private RemoteSystemService remoteSystemService;

    @AuthCanAccess
    @GetMapping(value = "/findAllApplication")
    public JsonRender findAllApplication(){

        List<SystemDto> apps = remoteSystemService.findAllSystem();

        JsonRender model = JsonRender.successResult();
        JSONArray applications = new JSONArray();
        for(SystemDto system:apps){
            JSONObject app = new JSONObject();
            app.put("alias",system.getAppNameAlias());
            app.put("name",system.getAppName());
            app.put("id",system.getId());
            applications.add(app);
        }
        model.put("applications",applications);
        return model;
    }

    @AuthCanAccess
    @GetMapping(value = "/findConcernApplications")
    public JsonRender findConcernApplications(){
        Set<String> applications = remoteSystemService.findAppAliasByAdminAndRelation(RequestTool.getAdminId(), AdminApplicationRelation.CONCERN);
        JsonRender model = JsonRender.successResult();
        model.put("applications",applications);
        return model;
    }



}
