package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.EnvironmentService;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.tool.TemplateUtils;
import cn.com.duiba.sso.ui.mume.MumeLoader;
import cn.com.duiba.sso.ui.mume.SsoUIMume;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class SsoUIResManager {

    @Value("classpath:temp/main.jsvm")
    private org.springframework.core.io.Resource mainJs;
    @Value("classpath:temp/index.html")
    private org.springframework.core.io.Resource mainHomeIndex;
    @Value("${ui.version:0.0.1}")
    private String uiVersion;

    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private MumeLoader mumeLoader;
    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;
    @Resource
    private EnvironmentService environmentService;

    private Map<String,String> jsMap = Maps.newConcurrentMap();

    private String webTitle = "服务综合治理平台";

    public void regestModule(String name,String configuration){
        jsMap.put(name,configuration);
    }

    public void setWebTitle(String webTitle) {
        this.webTitle = webTitle;
    }

    protected String indexHtml() throws IOException {

        JSONObject model = new JSONObject();
        model.put("rootPath",ssoProperties.getRootPath());
        model.put("webTitle",webTitle);

        Environment Environment = requestEnvironmentDecisionMaker.getRequestEnvironment();

        model.put("environment",Environment.getEnvId());
        model.put("cluster",environmentService.currentClusterKey());

        List<SsoUIMume> ssoUIMume =  mumeLoader.loadUIMume();

        model.put("mumeList", JSONArray.toJSONString(ssoUIMume));

        CharSource source = Resources.asCharSource(mainHomeIndex.getURL(), Charsets.UTF_8);
        return TemplateUtils.replaceArgs(source.read(),model);
    }


    protected String getMainJs() throws IOException {
        List<String> list = Lists.newArrayList();
        list.addAll(jsMap.keySet());
        String lists = JSONObject.toJSONString(list);
        String maps =  JSONObject.toJSONString(jsMap);

        JSONObject model = new JSONObject();
        model.put("rootMoudles",lists);
        model.put("rootMoudleMap",maps);
        model.put("uiVersion",uiVersion);


        CharSource source = Resources.asCharSource(mainJs.getURL(), Charsets.UTF_8);
        return TemplateUtils.replaceArgs(source.read(),model);
    }

    private List<SsoUIMume> traversal(List<SsoUIMume> ssoUIMumes){
        List<SsoUIMume> returnList = Lists.newArrayList();
        for(SsoUIMume mume:ssoUIMumes){
            returnList.add(mume);
            if(mume.getChild()!=null && !mume.getChild().isEmpty()){
                returnList.addAll(traversal(mume.getChild()));
            }
        }
        return returnList;
    }



}
