define([
    "angular",
    "/ui/lib/angular/function.js",
    "/ui/lib/angular/angular-ui-router.min.js",
    "/ui/lib/angular/angular-sanitize.min.js",
    "/ui/lib/angular/angular-resource.min.js",
    "/ui/lib/angular/angular-cookies.min.js",
    "/ui/lib/bootstrap/ui-bootstrap-tpls-0.14.3.min.js",
    "/ui/lib/animate/animate.js",
    "/ui/configuration/ui-sso-configuration.js",
    "/ui/directive/ui-directive-configuration.js",

    "css!/ui/less/build.css"
],function (angular) {
    "use strict";

    const boot = angular.module("ui.boot",[
        "ui.sso",
        "ui.file",
        "ui.router",
        "ngSanitize",
        "ngResource",
        "ngCookies",
        "ui.directive.ext",
        "ngAnimate-animate.css"
    ]);

    boot.run(Run);
    boot.service("mumeService",MumeService);
    boot.service('$ApplicationService', $ApplicationService);
    boot.directive('uiAppSelect', UiAppSelect);

    /** @ngInject **/
    function Run($rootScope,$http,$state,mumeService){

        $rootScope.$state = $state;
        $rootScope.isCollapsed = localStorage.getItem("isCollapsed")==='true';
        $rootScope.isCollapsed2 = localStorage.getItem("isCollapsed2")==='true';

        $rootScope.$stateAlias = "";
        $rootScope.mumeList = window.$$MumeList;
        $rootScope.secondList = [];
        $rootScope.$webTitle = window.$webTitle;

        mumeService.fengxiMume($rootScope.mumeList);

        $rootScope.$watch("isCollapsed",function (newValue) {
            localStorage.setItem("isCollapsed",newValue);
        });

        $rootScope.cherkCollapsed2 = function(){
            $rootScope.isCollapsed2 = !$rootScope.isCollapsed2;
            console.log($rootScope.isCollapsed2);
            localStorage.setItem("isCollapsed2",$rootScope.isCollapsed2);
        };

        $rootScope.$on('$stateNotFound',function(event, toState){
            const state = mumeService.getStateUrl({state: toState.to, params: toState.toParams});
            const nav = mumeService.getNavByState(state);
            if(!!nav){
                location.href = nav.url;
            }else{
                alert("没有"+toState.to+"对应的state");
            }
        });

        $rootScope.$watch("$stateAlias",function(alias){
            if(!!alias){
                mumeService.flushSocoundMume(alias);
            }
        });

        $rootScope.$stateIncludes = function(navState){
            return $rootScope.$stateAlias.indexOf(navState)===0;
        };

        $rootScope.$on('$stateChangeStart',function(){
            $rootScope.$stateAlias = "";
        });

        /**
         * 如果存在子菜单，就默认选择子菜单的第一项
         */
        $rootScope.$on('$stateChangeSuccess', function(event, toState, toParams, fromState, fromParams, options){
            $rootScope.stateName = toState.name;
            mumeService.flushSocoundMume($rootScope.stateName);
        });

        $rootScope.getStateName = function(){
            return angular.element(".sidebar-trans .active .nav-title").html();
        };

        $rootScope.getStateUrl = mumeService.getStateUrl;

        $rootScope.goBack = function(){
            history.go(-1);
        };

        $rootScope.getFristState = function(stateName){
            if(angular.isString(stateName)){
                var stateList = stateName.split(".");
                return stateList[0];
            }else{
                return "";
            }
        };
    }

    /** @ngInject **/
    function UiAppSelect($ApplicationService,$q){
        return {
            priority: 0,
            templateUrl: "/ui/directive/select/app-select.html",
            scope: {
                appAlias:"=",
                placeholder:"@",
                appListFilter:"="
            },
            controller:function($scope, $element, $attrs, $transclude){
                $scope.$appSelect = {};
                $scope.$appSelect.selected = {};
                $scope.$appSelect.$appList = [];
                $scope.appOrderBy = appOrderBy;
                $q.all([
                    $ApplicationService.findAllApplication(),
                    $ApplicationService.findConcernApplications()
                ]).then(function(dataArr){
                    var appList = dataArr[0];
                    if(angular.isFunction($scope.appListFilter)){
                        appList = $scope.appListFilter(appList);
                    }
                    $scope.$appSelect.$appList = appList;
                    var concern = new Set(dataArr[1]);
                    $scope.$appSelect.$appList.each(function(value){
                        value.concern = concern.has(value.alias);
                        if($scope.appAlias === value.alias){
                            $scope.$appSelect.selected = value;
                        }
                    });
                });

                function appOrderBy(app){
                    var sort = app.id;
                    if(app.concern){
                        sort = sort - 1000000;
                    }
                    return sort;
                }
            },
            restrict: 'E', // E = Element, A = Attribute, C = Class, M = Comment
            link:function ($scope, iElm, iAttrs, controller) {
                $scope.$watch("$appSelect.selected",function(newValue){
                    if(!!newValue && !!newValue.alias){
                        $scope.appAlias = newValue.alias;
                    }
                });
            }
        }
    }

    /** @ngInject **/
    function $ApplicationService($http,$q){


        function findAllApplication(){

            var defer = $q.defer();
            $http.get($rootPath+"/uiboot/findAllApplication").success(function(result){
                defer.resolve(result.applications);
            });
            return defer.promise;
        }

        function findConcernApplications(){
            var defer = $q.defer();
            $http.get($rootPath+"/uiboot/findConcernApplications").success(function(result){
                defer.resolve(result.applications);
            });
            return defer.promise;
        }

        return {
            findAllApplication:findAllApplication,
            findConcernApplications:findConcernApplications
        }
    }
    /** @ngInject **/
    function MumeService($cacheFactory,$http,$rootScope,$state) {

        var mumeCache = $cacheFactory('$$MumeCache');

        function flushSocoundMume(stateName) {
            stateName = !!$rootScope.$stateAlias ? $rootScope.$stateAlias:stateName;
            var fristState = $rootScope.getFristState(stateName);
            $rootScope.secondList = [];
            var mark = false;
            angular.forEach($rootScope.mumeList,function (nav) {
                if(nav.state===fristState){
                    $rootScope.secondList = !!nav.child?nav.child:[];
                    if(!$rootScope.secondList.length){
                        $rootScope.isCollapsed2 = false;
                    }else {
                        $rootScope.isCollapsed2 = localStorage.getItem("isCollapsed2")==='true';
                    }
                    mark = true;
                }
            });
            if(!mark){
                $rootScope.isCollapsed2 = false;
            }
        }

        function getNavByState(state) {
            return mumeCache.get(state);
        }

        function getStateUrl(nav){
            if(!nav) return "";
            var state = nav.state;
            if(!!nav.params && !!nav.params.length){
                state = state + "(" + angular.toJson(nav.params) + ")";
            }
            return state;
        }

        function fengxiMume(mumes) {
            var returnList = [];
            var list = [];

            var items = [].concat(mumes);
            angular.forEach(items, function (mume) {
                returnList.push(mume);
                if (!!mume.child && !!mume.child.length) {
                    list.push(mume);
                }
            });
            var nav;
            while (!!list.length) {
                nav = list.shift();
                items = nav.child;
                angular.forEach(items, function (mume) {
                    returnList.push(mume);
                    if (!!mume.child && !!mume.child.length) {
                        list.push(mume);
                    }
                });
            }
            returnList.each(function(item){
                mumeCache.put(getStateUrl(item),item);
            });
            return returnList;
        }

        return {
            getStateUrl:getStateUrl,
            fengxiMume:fengxiMume,
            getNavByState:getNavByState,
            flushSocoundMume:flushSocoundMume
        }
    }

    boot.filter('propsFilter', function() {
        return function(items, props) {
            var out = [];

            if (angular.isArray(items)) {
                var keys = Object.keys(props);

                items.forEach(function(item) {
                    var itemMatches = false;

                    for (var i = 0; i < keys.length; i++) {
                        var prop = keys[i];
                        var text = props[prop].toLowerCase();
                        if (item[prop].toString().toLowerCase().indexOf(text) !== -1) {
                            itemMatches = true;
                            break;
                        }
                    }

                    if (itemMatches) {
                        out.push(item);
                    }
                });
            } else {
                // Let the output be the input untouched
                out = items;
            }

            return out;
        };
    });

    return boot;
});