package cn.com.duiba.sso.ui;

import cn.com.duiba.sso.ui.enums.MenuType;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Data
@ConfigurationProperties(prefix = "duiba.sso.ui")
public class SsoUIProperties {

    //sso ui boot 是否打开
    private Boolean enabled;
    //ui boot 引用菜单的方式
    private MenuType menuType = MenuType.SSO_RESOURCE;
    //菜单引用源，系统方式：系统别名，文件方式：文件地址
    private String menuResource;

    private String webTitle = "服务综合治理平台";

}
