/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.sso.api.constants.SsoProperties;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
@WebFilter(filterName="uiBootFilter", urlPatterns={"/*"}, dispatcherTypes={DispatcherType.REQUEST})
public class SsoUiRootFilter
implements Filter {
    private String UI_BOOT_FORWARD_PATH = "/forward";
    @Resource
    private SsoProperties ssoProperties;
    private Boolean active = false;

    public void init(FilterConfig filterConfig) {
    }

    @PostConstruct
    public void initSsoUiRootFilter() {
        this.active = StringUtils.isNotBlank((String)this.ssoProperties.getRootPath()) && StringUtils.startsWith((String)this.ssoProperties.getRootPath(), (String)"/");
        this.UI_BOOT_FORWARD_PATH = this.ssoProperties.getRootPath() + this.UI_BOOT_FORWARD_PATH;
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String path = request.getRequestURI();
        if (!this.active.booleanValue() || !StringUtils.startsWith((String)path, (String)this.ssoProperties.getRootPath())) {
            chain.doFilter(req, response);
            return;
        }
        boolean needForward = StringUtils.startsWith((String)path, (String)this.UI_BOOT_FORWARD_PATH);
        if (!needForward) {
            chain.doFilter(req, response);
            return;
        }
        path = path.replace(this.UI_BOOT_FORWARD_PATH, "");
        request.getRequestDispatcher(path).forward((ServletRequest)request, response);
    }

    public void destroy() {
    }
}

