/**
 * Project Name:stock-service-api
 * File Name:ConsumeStockTypes.java
 * Package Name:cn.com.duiba.stock.service.api.constant
 * Date:2016年7月12日下午4:33:24
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
 */

package cn.com.duiba.stock.service.api.constant;

/**
 * ClassName:ConsumeStockTypes <br/>
 * Function: 扣积分的业务类型，组合type和reqBiz来唯一确定 <br/>
 * Date: 2016年7月12日 下午4:33:24 <br/>
 * 
 * @author xuhengfei
 * @version
 * @since JDK 1.6
 * @see
 */
public enum ConsumeStockTypes {
	/**
	 * 平台券下单减库存
	 */
	PcgItemTakeOrder(1),
	/**
	 * 广告减库存
	 */
	AcgTakeOrder(2),
	/**
	 * 兑吧商品下单减库存
	 */
	DuibaTakeOrder(3),
	/**
	 * APP商品下单减库存
	 */
	AppTakeOrder(4),
	/**
	 * 活动下单减库存
	 */
	ActivityOrder(5),
	/**
	 * QIHO(奇货)下单减库存
	 */
	QihoTakeOrder(6),

	/**
	 * 集卡锁定奖项减库存
	 */
	CLCardRewardStock(7),

	/**
	 * 活动工具库存
	 */
	HdToolStock(8),
	
	;

	private int type;

	private ConsumeStockTypes(int type) {
		this.type = type;
	}

	public int getType() {
		return type;
	}

}
