package cn.com.duiba.stock.service.api.constant;

/**
 * Created by xuezhaoming on 16/5/30.
 */
public enum STErrorCode {

    SS_0101001("SS_0101001", "库存中心-前台服务－外部错误-参数为空"),

    SS_0102001("SS_0102001", "库存中心-前台服务－内部错误"),

    SS_0102002("SS_0102002", "库存中心-前台服务－内部错误--查询库存错误"),

    SS_0102003("SS_0102003", "库存中心-前台服务－内部错误--新增库存错误"),

    SS_0102004("SS_0102004", "库存中心-前台服务－内部错误--减库存错误"),

    SS_0103001("SS_0103001", "库存中心-前台服务－依赖错误－发号器错误"),

    SS_0103002("SS_0103002", "库存中心-前台服务－依赖错误－redis错误"),

    SS_0201001("SS_0201001", "库存中心-后台服务－外部错误-参数为空"),

    SS_0202001("SS_0202001", "库存中心-后台服务－内部错误-参数为空"),
    
    SS_0203001("SS_0203001", "库存中心-后台服务－业务异常-数据库异常"),
    
    /**
     * 更新库存失败
     */
    SS_0400000("SS_0400000", "更新库存失败"),
    /**
     * 库存不足
     */
	SS_0400001("SS_0400001", "库存不足"),
	/**
	 * 重复扣库存
	 */
	SS_0400002("SS_0400002", "重复扣库存"),
	/**
	 * 参数无效
	 */
	SS_0400003("SS_0400003", "参数无效"),
	
	
	;

    private String code;

    private String desc;

    STErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
    
	public String getJson() {
		return "{\"" + code + "\":\"" + desc + "\"}";
	}
	
}
