package cn.com.duiba.stock.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.stock.service.api.dto.NewStockReqDto;
import cn.com.duiba.stock.service.api.dto.NewStockRespDto;
import cn.com.duiba.stock.service.api.dto.UpdateStockReqDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by xuezhaoming on 16/5/16.
 */
@AdvancedFeignClient
public interface RemoteStockBackendService {

    /**
     * 增加count 个指定库存ID的库存
     *
     * @param stockId 库存ID
     * @param count 库存个数
     * @return true :成功 flase : 失败
     */
    DubboResult<Boolean> increaseItemStock(long stockId, long count);

    /**
     * 减少count 个指定库存ID的库存
     *
     * @param stockId 库存ID
     * @param count 减少库存个数
     * @return true :成功 flase : 失败
     */
    DubboResult<Boolean> decreaseItemStock(long stockId, long count);
    
    /**
     * 批量增加库存
     * 
     * @param reqs 库存ID，库存数集合
     * @return
     */
    DubboResult<Boolean> increaseItemStockBatch(List<UpdateStockReqDto> reqs);

    /**
     * 批量减少库存
     * 
     * @param reqs 库存ID，库存数集合
     * @return
     */
    DubboResult<Boolean> decreaseItemStockBatch(List<UpdateStockReqDto> reqs);

    /**
     * 新增商品库存
     *
     * @param gid 商品ID
     * @param stock 库存量
     * @return 库存ID
     */
    DubboResult<Long> newStock(long gid, long stock);

    /**
     * 新增商品库存
     * @param gid 商品ID
     * @param currentStock 当前库存
     * @param totalStock 库存总量
     * @return 库存ID
     */
    DubboResult<Long> newTotalStock(long gid, long currentStock, long totalStock);
    
    /**
     * 批量创建库存
     * 
     * @param reqs List<NewStockReqDto> 商品ID初始化多少库存集合
     * @return List<NewStockRespDto> 商品ID对应库存ID集合
     */
    DubboResult<List<NewStockRespDto>> newStockBatch(List<NewStockReqDto> reqs);
    
    
    
    /**
     * 根据库存ID 查询库存
     * 
     * @param stockID 库存ID
     * @return 库存数据
     */
    DubboResult<Long> find(long stockID);

    /**
     * 获取总库存
     * 
     * @param stockId 库存ID
     * @return 总库存
     */
    DubboResult<Long> findTotalStock(long stockId);
}
