package cn.com.duiba.supplier.center.api.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 系统返回码
 * 返回码格式为 AABBB
 * AA:业务模块
 * BBB:具体错误类型
 */
public enum ResultCodeEnums {

    /** 00XXX 通用模块返回码 */
    RC_00001("00001", "调用成功"),
    RC_00002("00002", "调用失败"),

    /** 01XXX 采购单模块 */
    RC_01001("01001", "此类型无法下单"),

    ;

    private String code;

    private String message;

    ResultCodeEnums (String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    private static Map<String, ResultCodeEnums> ALL_MAP;

    static {
        Map<String, ResultCodeEnums> temp = Maps.newHashMap();
        Arrays.stream(values()).forEach(code -> temp.put(code.getCode(), code));
        ALL_MAP = ImmutableMap.copyOf(temp);
    }

    public static ResultCodeEnums findByCode(String code) {
        return ALL_MAP.get(code);
    }

}
