package cn.com.duiba.supplier.center.api.response;


import cn.com.duiba.supplier.center.api.enums.ResultCodeEnums;

/**
 * Created by hww on 2018/11/28 12:03 PM.
 */
public class ReceivedOrderResponse extends AbstractResponse {

    private static final long serialVersionUID = -2489614306940166943L;

    public static ReceivedOrderResponse success() {
        ReceivedOrderResponse response = new ReceivedOrderResponse();
        response.setSuccess(true);
        response.setResultCode(ResultCodeEnums.RC_00001.getCode());
        response.setResultMessage(ResultCodeEnums.RC_00001.getMessage());
        return response;
    }

    public static ReceivedOrderResponse fail() {
        return fail(ResultCodeEnums.RC_00002);
    }

    public static ReceivedOrderResponse fail(ResultCodeEnums code) {
        return fail(code.getCode(), code.getMessage());
    }

    public static ReceivedOrderResponse fail(String code, String message) {
        ReceivedOrderResponse response = new ReceivedOrderResponse();
        response.setSuccess(false);
        response.setResultCode(code);
        response.setResultMessage(message);
        return response;
    }



}
