package cn.com.duiba.supplier.center.api.request.purchase;

import cn.com.duiba.supplier.center.api.enums.PurchaseTypeEnum;
import cn.com.duiba.supplier.center.api.request.PurchaseRequest;

/**
 * 支付宝下单请求参数
 * Created by hww on 2018/12/3 1:55 PM.
 */
public class AliPayPurchaseRequest extends PurchaseRequest {

    private static final long serialVersionUID = 3037534465509599522L;
    /** 必传 支付宝账号 */
    private String account;
    /** 必传 真实姓名 */
    private String realName;
    /** 必传 充值金额 */
    private Long price;
    /** 必传 商品id */
    private Long itemId;

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    @Override
    public String getApiMethodName() {
        return PurchaseTypeEnum.ALI_PAY.name();
    }
}
