/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.supplier.center.api.enums;

import com.google.common.collect.ImmutableSet;

public enum PurchaseTypeEnum {
    OBJECT("\u5b9e\u7269\u8ba2\u5355", "object"),
    COUPON("\u4f18\u60e0\u5238", "coupon"),
    QB("Q\u5e01", "qb"),
    PHONE_BILL("\u624b\u673a\u8bdd\u8d39", "phonebill"),
    PHONE_FLOW("\u624b\u673a\u6d41\u91cf", "phoneflow"),
    ALI_PAY("\u652f\u4ed8\u5b9d", "alipay");

    private String desc;
    private String itemType;
    private static final ImmutableSet<String> NO_STOCK_TYPE;

    private PurchaseTypeEnum(String desc, String itemType) {
        this.desc = desc;
        this.itemType = itemType;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getItemType() {
        return this.itemType;
    }

    public static boolean isNoStockType(String name) {
        return NO_STOCK_TYPE.contains((Object)name);
    }

    public static String getItemType(String name) {
        return PurchaseTypeEnum.valueOf((String)name).itemType;
    }

    static {
        NO_STOCK_TYPE = ImmutableSet.of((Object)ALI_PAY.name(), (Object)PHONE_BILL.name(), (Object)PHONE_FLOW.name(), (Object)QB.name());
    }
}

