package cn.com.duiba.supplier.center.api.request.purchase;

import cn.com.duiba.supplier.center.api.enums.PurchaseTypeEnum;
import cn.com.duiba.supplier.center.api.params.SkuParam;
import cn.com.duiba.supplier.center.api.request.PurchaseRequest;

import java.util.List;

/**
 * 实物下单请求参数
 * Created by hww on 2018/11/28 2:54 PM.
 */
public class ObjectPurchaseRequest extends PurchaseRequest {

    private static final long serialVersionUID = -118758513271621358L;

    /** 必传 购买商品信息 */
    private List<SkuParam> sku;
    /** 必传 收货人姓名 */
    private String name;
    /** 必传 收货人手机号 */
    private String phone;
    /** 必传 省 */
    private String province;
    /** 必传 市 */
    private String city;
    /** 必传 区、县 */
    private String area;
    /** 必传 街道 */
    private String district;
    /** 必传 详细收货地址 */
    private String address;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public List<SkuParam> getSku() {
        return sku;
    }

    public void setSku(List<SkuParam> sku) {
        this.sku = sku;
    }

    public String getApiMethodName() {
        return PurchaseTypeEnum.OBJECT.name();
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }
}
