package cn.com.duiba.supplier.center.api.remoteservice.orders;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.SupplierCallbackDto;

/**
 * @program: supplier-center
 * @description: 供应商接口回调
 * @author: Simba
 * @create: 2018-12-19 19:33
 **/
@AdvancedFeignClient
public interface RemoteSupplierCallbackService {

    /**
     * 支付宝支付回调
     * @param supplyDeliveryNum
     * @return
     */
    boolean alipayCallback(String supplyDeliveryNum, boolean isSuccess, String msg) throws Exception;

    /**
     * 话费回调
     * @param supplierCallbackDto
     * @return
     * @throws Exception
     */
    boolean phonebillCallback(SupplierCallbackDto supplierCallbackDto) throws Exception;

    /**
     * QB回调
     * @param supplierCallbackDto
     * @return
     */
    boolean qbCallback(SupplierCallbackDto supplierCallbackDto) throws Exception;
}

