package cn.com.duiba.supplier.center.api.request.order;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by hww on 2018/12/13 3:23 PM.
 */
public class QueryOrderListRequest implements Serializable {
    private static final long serialVersionUID = -4716832017931150419L;

    /** 全部 */
    public static final int ITEM_TYPE_ALL = 1;
    /** 实物 */
    public static final int ITEM_TYPE_OBJECT = 2;
    /** 卡券 */
    public static final int ITEM_TYPE_COUPON = 3;
    /** 充值 */
    public static final int ITEM_TYPE_RECHARGE = 4;

    /** 供应商id */
    private Integer supplierType;
    /** 充值账号 */
    private String account;
    /** 收货人姓名 */
    private String name;
    /** 收货人手机号 */
    private String phone;
    /** 下单起始时间 */
    private Date startTime;
    /** 下单截止时间 */
    private Date endTime;
    /** 商品类型 */
    private Integer itemType;
    /** 订单状态 */
    private Integer orderStatus;
    /** 查询页码 按照实际页码来 第一页传1 默认查询第一页 */
    private Integer pageNo;
    /** 分页大小 默认查询20条 */
    private Integer pageSize;

    public Integer getSupplierType() {
        return supplierType;
    }

    public void setSupplierType(Integer supplierType) {
        this.supplierType = supplierType;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
