package cn.com.duiba.supplier.center.api.remoteservice.supply;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuiBaSupplyOrdersDto;
import cn.com.duiba.supplier.center.api.request.order.DuiBaSupplyOrderPurchaseRequest;
import cn.com.duiba.supplier.center.api.request.order.QueryDuiBaSupplyOrdersPageRequest;
import cn.com.duiba.supplier.center.api.response.PurchaseOrderResponse;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDuiBaSupplyOrderService {

    PurchaseOrderResponse purchaseOrder(DuiBaSupplyOrderPurchaseRequest request);

    DuiBaSupplyOrdersDto findByThirdOrderNumAndAppId(String thirdOrderNum, Long appId);

    List<DuiBaSupplyOrdersDto> findByThirdOrderNum(String thirdOrderNum);

    DuiBaSupplyOrdersDto findBySupplyOrderNum(Long supplyOrderNum);

    boolean expressSend(Long supplyOrderNum, String expressName, String expressNo);

    Page<DuiBaSupplyOrdersDto> findPage(QueryDuiBaSupplyOrdersPageRequest query);

    Integer findTotalCount(QueryDuiBaSupplyOrdersPageRequest query);

    List<DuiBaSupplyOrdersDto> findList(QueryDuiBaSupplyOrdersPageRequest query);

}
