package cn.com.duiba.supplier.center.api.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 系统返回码
 * 返回码格式为 AABBB
 * AA:业务模块
 * BBB:具体错误类型
 */
public enum ErrorCodeEnums {

    /** 00XXX 通用模块返回码 */
    RC_00001("00001", "调用成功"),
    RC_00002("00002", "调用失败"),
    /** 参数错误 */
    RC_00003("00003", "参数错误"),

    /** 01XXX 采购单模块 */
    RC_01001("01001", "此类型无法下单"),
    RC_01002("01002", "订单号不能为空"),
    RC_01003("01003", "第三方订单号不能为空"),
    RC_01004("01004", "分销商id不能为空"),
    RC_01005("01005", "下单ip不能为空"),
    RC_01006("01006", "分销商id不能为空"),
    RC_01007("01007", "此环境不支持下单"),

    RC_01012("01012", "购买商品不支持"),
    RC_01014("01014", "sku不能为空"),
    RC_01017("01017", "购买的商品不存在"),
    RC_01018("01018", "sku商品不存在"),

    //实物参数校验
    RC_01019("01019", "匹配不到京东省市信息"),
    RC_01020("01020", "收货省份信息不能为空"),
    RC_01021("01021", "收货城市信息不能为空"),
    RC_01022("01022", "收货县区信息不能为空"),
    RC_01023("01023", "收货街道信息不能为空"),
    RC_01024("01024", "收货地址不能为空"),
    RC_01025("01025", "收货人姓名不能为空"),
    RC_01026("01026", "收货联系电话不能为空"),

    RC_01027("01027", "不能购买不同供应商的商品"),
    RC_01028("01028", "商品扣库存失败"),
    RC_01029("01029", "运费模板不存在，匹配失败！"),
    RC_01030("01030", "收货地址不全"),
    RC_01031("01031", "暂不支持此地址"),

    //确认采购单
    RC_01040("01040", "更新更新加速表状态失败"),
    RC_01041("01041", "商品子订单不存在"),
    RC_01042("01042", "充值供应商待结算账户失败"),
    RC_01043("01043", "更新采购单为待发货状态失败"),
    RC_01044("01044", "创建发货单失败"),
    RC_01045("01045", "更新发货单id失败"),

    //取消采购单
    RC_01046("01046", "采购单不存在"),
    RC_01047("01047", "采购单状态错误"),
    RC_01048("01048", "更新采购单状态失败"),

    //确认发货
    RC_01049("01049", "扣除供应商待结算账户失败"),
    RC_01050("01050", "充值供应商资产账户失败"),

    //京东商品获取
    RC_01051("01051", "获取京东token失败"),
    RC_01052("01052", "从缓存中获取京东token失败"),
    RC_01053("01053", "刷新京东token失败"),
    RC_01054("01054", "获取京东地址失败"),
    RC_01055("01055", "匹配不到京东区镇信息"),
    RC_01056("01056", "获取京东商品失败"),
    RC_01057("01057", "检查可售状态失败"),
    RC_01058("01058", "获取京东商品详情失败"),
    RC_01059("01059", "获取京东商品库存失败"),
    RC_01060("01060", "获取京东商品售卖价失败"),
    RC_01061("01061", "找不到相应规格项"),
    RC_01062("01062", "商品更新失败"),
    RC_01063("01063", "push规格属性变更到appItem失败"),
    RC_01064("01064", "获取京东商品图片失败"),
    RC_01065("01065", "京东商品信息推送获取失败"),
    RC_01066("01066", "京东商品上下架状态获取失败"),
    RC_01067("01067", "删除京东推送消息失败"),
    RC_01068("01068", "取消京东订单失败"),
    RC_01069("01069", "京东商品区域购买限制获取失败"),
    RC_01070("01070", "京东商品可售性状态获取失败"),
    RC_01071("01071", "查询京东订单失败"),
    RC_01072("01072", "查询京东订单物流配送失败"),

    RC_01090("01090", "京东商品下单失败"),
    RC_01091("01091", "京东商品确认失败"),
    RC_01092("01092", "京东商品反查失败"),
    RC_01093("01093", "商品不可售"),
    RC_01094("01094", "非预占库存订单不能取消"),

    RC_02000("02000", "没有相应的供应商信息"),
    /** 02XXX 兑吧采购单模块 */
    RC_02001("02001", "下单失败"),
    RC_02002("02002", "兑换券已经用完"),
    ;

    private String code;

    private String message;

    ErrorCodeEnums(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    private static Map<String, ErrorCodeEnums> ALL_MAP;

    static {
        Map<String, ErrorCodeEnums> temp = Maps.newHashMap();
        Arrays.stream(values()).forEach(code -> temp.put(code.getCode(), code));
        ALL_MAP = ImmutableMap.copyOf(temp);
    }

    public static ErrorCodeEnums findByCode(String code) {
        return ALL_MAP.get(code);
    }

}
