package cn.com.duiba.supplier.center.api.enums;

/**
 * 新兑吧供应商类型
 * Created by sunyan on 2020/4/13.
 */
public enum SupplyTypeNewEnum {
    DUIBA(0, "兑吧",true),
    JD(1, "京东",true),
    YAN_XUAN(2, "网易严选",true),
    LIN_ZHEN(3, "霖臻",false),
    NEW_EGG(4, "新蛋",true),
    ZHAI_JIA(5, "宅佳",false),
    FEI_REN(6, "飞人",true),
    HAI_LAI_YUN_SHI(7, "海莱云视",false),
    JDNEW(8, "京东",false),
    ZHONG_XI(9, "重禧",false),
    JIE_HU_WEI(10, "洁护卫",false),
    XUN_XIAO(11, "迅销",false),
    MI_GAO(12, "米羔",false),
    FU_LU(13, "福禄",false),
    YA_DUO(14, "亚朵",false);

    private int code;
    private String desc;
    private boolean deleted;

    SupplyTypeNewEnum(int code, String desc,boolean deleted) {
        this.code = code;
        this.desc = desc;
        this.deleted=deleted;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public static SupplyTypeNewEnum ofCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (SupplyTypeNewEnum type : values()) {
            if (code == type.getCode()) {
                return type;
            }
        }
        return null;
    }
}
