package cn.com.duiba.supplier.center.api.remoteservice.orders;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.SupplyProductOrdersDto;

import java.util.List;

/**
 * Created by hww on 2018/12/17 11:49 AM.
 */
@AdvancedFeignClient
public interface RemoteSupplyProductOrdersBackedService {

    /**
     * 根据采购单号查询所有商品子订单
     */
    List<SupplyProductOrdersDto> selectBySupplyOrderNum(Long supplyOrderNum);

    /**
     * 批量根据采购单号查询所有商品子订单
     * 至多一次查询100个采购单号  超过100个 返回空集合
     */
    List<SupplyProductOrdersDto> selectBySupplyOrderNumList(List<Long> supplyOrderNums);

    /**
     * 根据id集合查询
     * @param idList
     * @return
     */
    List<SupplyProductOrdersDto> selectByIdList(List<Long> idList);
}
