package cn.com.duiba.supplier.center.api.remoteservice.orders;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.SupplyDeliveryDto;

import java.util.List;


/**
 * Created by hww on 2018/12/13 3:16 PM.
 */
@AdvancedFeignClient
public interface RemoteSupplyDeliveryBackedService {

    /**
     * 根据采购单号查询发货单
     */
    List<SupplyDeliveryDto> findBySupplyOrderNum(Long supplyOrderNum);

    /**
     * 根据id查询发货单
     * @param id
     * @return
     */
    SupplyDeliveryDto findById(Long id);

    /**
     * 根据采购单号查询发货单
     */
    List<SupplyDeliveryDto> findBySupplyOrderNumList(List<Long> supplyOrderNumList);

//    /**
//     * 分页查询失败的发货单
//     * @param pageNo
//     * @param pageSize
//     * @return
//     */
//    Page<SupplyDeliveryDto> findPageWithFail(Integer pageNo, Integer pageSize);
//
//    /**
//     * 卡单情况下，相关人员确认后可直接对发货单进行强制失败
//     * @param supplyDeliveryId
//     * @return
//     */
//    int forceMake2Fail(Long supplyDeliveryId) throws BizException;
//
//    /**
//     * 卡单情况下，相关人员确认后可直接对发货单进行强制成功
//     * @param supplyDeliveryId
//     * @return
//     */
//    int forceMake2Success(Long supplyDeliveryId) throws BizException;

    /**
     * 根据id集合查询
     * @param idList
     * @return
     */
    List<SupplyDeliveryDto> selectByIdList(List<Long> idList);


}
