package cn.com.duiba.supplier.center.api.remoteservice.orders;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuibaUpdateLogisticsDto;
import cn.com.duiba.supplier.center.api.dto.ManualDeliveryDto;
import cn.com.duiba.supplier.center.api.dto.UpdateLogisticsDto;

/**
 * @program: supplier-center
 * @description: 物流服务接口
 * @author: Simba
 * @create: 2018-12-25 18:03
 **/
@AdvancedFeignClient
public interface RemoteLogisticsServerService {

    /**
     * 商品手动发货
     *
     * @param manualDeliveryDto
     * @return
     * @throws BizException
     */
    Long goodsManualDelivery(ManualDeliveryDto manualDeliveryDto) throws BizException;

    /**
     * 主订单关联发货
     *
     * @param manualDeliveryDto
     * @return
     * @throws BizException
     */
    Long goodsManualDelivery4Main(ManualDeliveryDto manualDeliveryDto);

    /**
     * 商品物流信息修改
     *
     * @param updateLogisticsDto
     * @return
     * @throws BizException
     */
    int updateLogisticsInfo(UpdateLogisticsDto updateLogisticsDto) throws BizException;


    /**
     * 管理端商品物流信息修改同步
     *
     * @param updateLogisticsDto
     * @return
     * @throws BizException
     */
    int updateLogisticsInfo4Duiba(UpdateLogisticsDto updateLogisticsDto);

    /**
     * 兑吧管理后台修改物流信息同步
     * @param updateLogisticsDto
     * @return
     */
    int duibaUpdateLogisticsInfo(DuibaUpdateLogisticsDto updateLogisticsDto);

}
