package cn.com.duiba.supplier.center.api.enums;

/**
 * 新兑吧供应商类型
 * Created by sunyan on 2020/4/13.
 */
public enum SupplyTypeNewEnum {
    DUIBA(0, "兑吧",true),
    JD(1, "京东",true),
    YAN_XUAN(2, "网易严选",true),
    LIN_ZHEN(3, "霖臻",false),
    NEW_EGG(4, "新蛋",true),
    ZHAI_JIA(5, "宅佳",false),
    FEI_REN(6, "飞人",true),
    HAI_LAI_YUN_SHI(7, "海莱云视",true),
    JDNEW(8, "京东",false),
    ZHONG_XI(9, "重禧",true),
    JIE_HU_WEI(10, "洁护卫",true),
    XUN_XIAO(11, "迅销",true),
    MI_GAO(12, "米羔",false),
    FU_LU(13, "福禄",false),
    YA_DUO(14, "亚朵",true),
    QING_TIAN(15, "晴天",false),
    FU_YI_LIN(16, "富奕霖", false),
    ZAN_GE(17,"赞格",false),
    YOU_YIN(18,"有印",false),
    YUAN_LONG_YA_TU(19,"元隆雅图",false),
    SHUI_YANG(20, "水羊", false),
    PU_SHANG(21, "浦上", false),
    MENG_NIU(22, "蒙牛", false),
    ZHONG_LIANG(23, "中粮", false),
    SUPPLIER_PLATFORM(24, "直播供应商平台", true),
    CHANGBA(25, "唱吧", false),
    NABA(26, "拿吧", false),
    ;

    private int code;
    private String desc;
    private boolean deleted;

    SupplyTypeNewEnum(int code, String desc,boolean deleted) {
        this.code = code;
        this.desc = desc;
        this.deleted=deleted;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public static SupplyTypeNewEnum ofCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (SupplyTypeNewEnum type : values()) {
            if (code == type.getCode()) {
                return type;
            }
        }
        return null;
    }
}
