package cn.com.duiba.supplier.center.api.remoteservice.supply;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuiBaSupplyOrdersDto;
import cn.com.duiba.supplier.center.api.enums.DuiBaSupplyOrdersStatusEnum;
import cn.com.duiba.supplier.center.api.request.order.DuiBaSupplyOrderPurchaseRequest;
import cn.com.duiba.supplier.center.api.request.order.QueryDuiBaSupplyOrdersPageRequest;
import cn.com.duiba.supplier.center.api.request.order.QuerySupplyDTO;
import cn.com.duiba.supplier.center.api.request.order.SupplyOrderInfoRequest;
import cn.com.duiba.supplier.center.api.response.PurchaseOrderResponse;
import org.apache.commons.collections.CollectionUtils;

import java.util.Collections;
import java.util.List;

@AdvancedFeignClient
public interface RemoteDuiBaSupplyOrderService {

    PurchaseOrderResponse purchaseOrder(DuiBaSupplyOrderPurchaseRequest request);

    DuiBaSupplyOrdersDto findByThirdOrderNumAndAppId(String thirdOrderNum, Long appId);

    List<DuiBaSupplyOrdersDto> findByThirdOrderNum(String thirdOrderNum);

    /**
     * 使用参数查询
     * 供应商主订单号 经销商主单号
     * @param querySupplyDTO
     * @return
     */
    List<DuiBaSupplyOrdersDto> findByParams(QuerySupplyDTO querySupplyDTO);

    DuiBaSupplyOrdersDto findBySupplyOrderNum(Long supplyOrderNum);

    boolean updateRemarksByOrderNum(Long supplyOrderNum, String remarks);

    @Deprecated
    boolean expressSend(Long supplyOrderNum, String expressName, String expressNo);

    boolean expressSendNew(Long supplyOrderNum, Long ordersItemId, String expressName, String expressNo);

    Page<DuiBaSupplyOrdersDto> findPage(QueryDuiBaSupplyOrdersPageRequest query);

    Integer findTotalCount(QueryDuiBaSupplyOrdersPageRequest query);

    List<DuiBaSupplyOrdersDto> findList(QueryDuiBaSupplyOrdersPageRequest query);

    /**
     * 取消待发货实物订单
     * @param supplyOrderNum  采购单号
     * @param cancelReason    取消原因
     * @throws BizException   取消失败抛出异常
     */
    @Deprecated
    void cancelObjectOrder(Long supplyOrderNum, String cancelReason) throws BizException;

    /**
     * 取消待发货实物订单，子订单纬度
     * @param supplyOrderNum
     * @param ordersItemId
     * @param cancelReason
     * @throws BizException
     */
    void cancelObjectOrderNew(Long supplyOrderNum, Long ordersItemId, String cancelReason) throws BizException;

    /**
     * 根据采购单号 查询APP名称
     * DuiBaSupplyOrdersDto对象只会返回两个值  appName和supplyOrderNum,supplier,sku_info
     * @param supplyOrderNums
     * @return
     */
    List<DuiBaSupplyOrdersDto> findAppNameBySupplyOrderNum(List<Long> supplyOrderNums);

    /**
     * 新供应商采购单
     * 填充供应商父子单号&经销商父子单号
     * @param supplyOrderInfoRequest
     * @return
     */
    boolean updateOrderInfo(SupplyOrderInfoRequest supplyOrderInfoRequest);

    /**
     * 查找最新的一条采购单
     * @param appId
     * @return
     */
    DuiBaSupplyOrdersDto findBestNewByAppId(Long appId);

    /**
     * 根据采购单号查询数据
     */
    List<DuiBaSupplyOrdersDto> findListBySupplyOrderNum(List<Long> list);

    /**
     * 根据三方订单号查询数据
     */
    List<DuiBaSupplyOrdersDto> findListByThirdOrderNum(List<String> list);

    /**
     * 采购单强制成功
     * @param supplyOrderNum
     * @param remark
     * @return
     */
    Boolean maskOrderComplete(Long supplyOrderNum, DuiBaSupplyOrdersStatusEnum statusEnum, String remark) throws BizException;
}
