package cn.com.duiba.supplier.center.api.dto.supplier;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Date 2023/5/16 19:21
 * @Author LuHui
 */
public class PhonebillSupplyChannelRecordDto implements Serializable {

    private static final long serialVersionUID = -2510501577484587484L;
    /**
     * 自增主键
     */
    private Long id;

    /**
     * appId
     */
    private Long appId;

    /**
     * developerId
     */
    private Long developerId;

    /**
     * 采购单单号
     */
    private Long supplyOrderNum;

    /**
     * 第三方渠道的订单号
     */
    private String thirdOrderNum;

    /**
     * 充值时间
     */
    private Date rechargeTime;

    /**
     * 充值状态 0-初始化 1-充值处理中 2-充值成功 3-充值失败
     */
    private Integer rechargeStatus;

    /**
     * 充值失败原因
     */
    private String failReason;

    /**
     * 手机号
     */
    private String phoneNumber;

    /**
     * 档位，单位分，多档位话费时使用
     */
    private Integer phoneDegree;

    /**
     * 面值，单位分，话费的面值，例如：5元话费记为500
     */
    private Integer phoneFacePrice;

    /**
     * 运营商，例如：中国移动
     */
    private String phoneCatName;

    /**
     * 归属地，省份，例如：浙江
     */
    private String phoneProvince;

    /**
     * 开发者付费金额，单位分
     */
    private Integer phoneActualPrice;

    /**
     * 兑吧的供应商产品id，supplier_product主键id
     */
    private Long supplierProductId;

    /**
     * 兑吧供应商产品名称，supplier_product字段supplier
     */
    private String supplierName;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public Long getSupplyOrderNum() {
        return supplyOrderNum;
    }

    public void setSupplyOrderNum(Long supplyOrderNum) {
        this.supplyOrderNum = supplyOrderNum;
    }

    public String getThirdOrderNum() {
        return thirdOrderNum;
    }

    public void setThirdOrderNum(String thirdOrderNum) {
        this.thirdOrderNum = thirdOrderNum;
    }

    public Date getRechargeTime() {
        return rechargeTime;
    }

    public void setRechargeTime(Date rechargeTime) {
        this.rechargeTime = rechargeTime;
    }

    public Integer getRechargeStatus() {
        return rechargeStatus;
    }

    public void setRechargeStatus(Integer rechargeStatus) {
        this.rechargeStatus = rechargeStatus;
    }

    public String getFailReason() {
        return failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Integer getPhoneDegree() {
        return phoneDegree;
    }

    public void setPhoneDegree(Integer phoneDegree) {
        this.phoneDegree = phoneDegree;
    }

    public Integer getPhoneFacePrice() {
        return phoneFacePrice;
    }

    public void setPhoneFacePrice(Integer phoneFacePrice) {
        this.phoneFacePrice = phoneFacePrice;
    }

    public String getPhoneCatName() {
        return phoneCatName;
    }

    public void setPhoneCatName(String phoneCatName) {
        this.phoneCatName = phoneCatName;
    }

    public String getPhoneProvince() {
        return phoneProvince;
    }

    public void setPhoneProvince(String phoneProvince) {
        this.phoneProvince = phoneProvince;
    }

    public Integer getPhoneActualPrice() {
        return phoneActualPrice;
    }

    public void setPhoneActualPrice(Integer phoneActualPrice) {
        this.phoneActualPrice = phoneActualPrice;
    }

    public Long getSupplierProductId() {
        return supplierProductId;
    }

    public void setSupplierProductId(Long supplierProductId) {
        this.supplierProductId = supplierProductId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
