package cn.com.duiba.supplier.center.api.enums;

/**
 * Created by sunyan on 2020/4/15.
 */
public enum SupplyOrderTypeEnum {
    JD(0, "京东订单"),
    MAIN(1, "主订单采购"),
    DUIBA_SUPPLY(2, "兑吧采购订单");

    private int code;
    private String desc;

    SupplyOrderTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static SupplyOrderTypeEnum ofCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (SupplyOrderTypeEnum type : values()) {
            if (code == type.getCode()) {
                return type;
            }
        }
        return null;
    }
}
