package cn.com.duiba.supplier.center.api.remoteservice.supply;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuiBaSubSupplyOrdersDto;

import java.util.Date;
import java.util.List;

/**
 * 子采购单处理remote
 *
 * @author yangyukang
 */
@AdvancedFeignClient
public interface RemoteDuiBaSubSupplyOrderService {

    boolean insert(DuiBaSubSupplyOrdersDto entity);

    int batchInsert(List<DuiBaSubSupplyOrdersDto> duiBaSubSupplyOrdersDtos);

    List<DuiBaSubSupplyOrdersDto> selectBySupplyOrderNum(Long supplyOrderNum);

    List<DuiBaSubSupplyOrdersDto> selectBySupplyOrderNumList(List<Long> supplyOrderNumList);

    DuiBaSubSupplyOrdersDto selectBySubSupplyOrderNum(Long subSupplyOrderNum);

    List<DuiBaSubSupplyOrdersDto> selectBySupplyOrderNums(List<Long> subSupplyOrderNums);

    boolean updateToProcessing(Long supplySubOrderNum);

    boolean updateToSuccess(Long supplySubOrderNum);

    boolean updateToFail(Long supplySubOrderNum, String failReason);


    /**
     * 查询初始化订单，时间小于当天
     *
     * @param pageNo
     * @param pageSize
     * @return
     */
    @Deprecated
    List<DuiBaSubSupplyOrdersDto> queryListByInit(Integer pageNo, Integer pageSize);

    List<DuiBaSubSupplyOrdersDto> findListByAppIdAndStatusAndModifiedTime(Long appId, List<Integer> orderStatusList, Date startTime, Date endTime);

    List<DuiBaSubSupplyOrdersDto> findListByAppIdAndStatusAndCreateTime(Long appId, List<Integer> orderStatusList, Date startTime, Date endTime);
    /**
     * 查询初始化订单，时间小于当天
     *
     * @param appId
     * @param pageNo
     * @param pageSize
     * @return
     */
    List<DuiBaSubSupplyOrdersDto> queryListByInitNew(Long appId, Integer pageNo, Integer pageSize);
}
