package cn.com.duiba.supplier.center.api.remoteservice.supply;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.ThirdCouponDTO;
import cn.com.duiba.supplier.center.api.params.SupplyOrderPageParam;
import cn.com.duiba.supplier.center.api.params.ThirdCouponPageParam;
import cn.com.duiba.supplier.center.api.params.ThirdCouponQueryParam;

import java.util.List;

/**
 * 三方卡券服务
 * @author lyj
 */
@AdvancedFeignClient
public interface RemoteThirdCouponRecordService {


    /**
     * 查询订单
     * @param param 查询参数
     * @return 订单信息
     */
    ThirdCouponDTO selectOrder(ThirdCouponQueryParam param);


    /**
     * 根据ID更新订单状态
     * @param entity 订单信息
     * @return 结果
     */
    int updateById(ThirdCouponDTO entity);


    /**
     * 插入数据
     */
    Long insert(ThirdCouponDTO entity);

    /**
     * 分页查询数据
     * @param param 请求参数
     * @return 分页数据
     */
    List<ThirdCouponDTO> selectPage(ThirdCouponPageParam param);

    /**
     * 查询分页数量
     * @param param 请求参数
     * @return 分页数据
     */
    Long selectCount(ThirdCouponPageParam param);

}
