package cn.com.duiba.supplier.channel.service.api.remoteservice.hanglvzongheng;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.BaseReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.hanglvzongheng.HangLvZongHengZcReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResultResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.hanglvzongheng.HangLvZongHengZcResp;
import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;

/**
 * @author: LuHui
 * @date: 2024/3/26 11:05
 * @description:
 */
@AdvancedFeignClient
public interface RemoteHangLvZongHengZcService {

    /**
     * 发放
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     *
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp distribute(BaseReq<HangLvZongHengZcReq> request);

    /**
     * 查询发放结果
     *
     * @param bizType 业务类型
     *                {@link BizTypeEnum}
     * @param bizNo   业务方唯一单号
     * @return 发放结果
     */
    BaseResultResp<HangLvZongHengZcResp> distributeResult(Integer bizType, String bizNo);

    /**
     * 第三方通知结果
     *
     * @param body 通知消息体
     * @return 是否处理成功
     */
    boolean notify(String body);
}
