package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author zzy
 * @create 2024/03/14 19:31
 **/
@Getter
@AllArgsConstructor
public enum ShenbianyunCodeEnum {
    // 三方错误码
    S0000("0000", "成功"),
    S6000("6000", "系统错误"),
    S6001("6001", "参数错误"),
    S6003("6003", "企业信息不存在"),
    S6004("6004", "客户状态未开通"),
    S6005("6005", "客户秘钥为空"),
    S6006("6006", "请求数据验签失败"),
    S6007("6007", "请求数据解密失败"),
    S6011("6011", "客户请求地址未配置白名单"),
    S6013("6013", "付款金额超限"),
    S6014("6014", "信息入库失败"),
    S6016("6016", "该用户信息已经做过签约"),
    S6019("6019", "账户余额不足"),
    S6020("6020", "未查询到订单"),
    S6028("6028", "未查询到对应的平台服务商"),
    S6030("6030", "商户id不能为空"),
    S6032("6032", "该商户批次号不存在"),
    S6033("6033", "商户订单号或者订单流水号不存在"),
    S6042("6042", "请求频繁请稍后再试"),
    S6048("6048", "风控审核未通过"),
    S6051("6051", "客户订单号重复,请确认订单信息"),
    S6053("6053", "该客户费率未配置"),
    S6067("6067", "商户公钥格式错误"),
    S6220("6220", "暂无电子回单"),
    S6301("6301", "零钱发放时未上传收款人名称微信无法生成电子回单"),
    S6302("6302", "企业服务商信用账户配置异常"),
    S6303("6303", "业务产品未开通"),
    S6304("6304", "客户限额未配置"),
    S6305("6305", "超出客户限额配置"),
    // 内部定义的错误码
    E100001("100001", "http请求错误,http code不是200:"),
    E100002("100002", "身边云响应错误:"),
    E100003("100003", "响应验签失败"),
    E100004("100004", "身边云加解密失败"),
    E900001("900001", "未知错误码"),
    E999999("999999", "身边云请求错误"),
    ;
    private final String code;

    private final String desc;
    //未落库状态
    public static final List<String> FAIL_CODE_LIST = Collections.unmodifiableList(Arrays.asList(S6020.getCode(),S6032.getCode(), S6033.getCode()));

    public static ShenbianyunCodeEnum getByCode(String code) throws BizException {
        for (ShenbianyunCodeEnum codeEnum : values()) {
            if (codeEnum.getCode().equals(code)) {
                return codeEnum;
            }
        }
        throw new BizException(E900001.desc).withCode(E900001.code);
    }
}
