package cn.com.duiba.supplier.channel.service.api.dto.request.ccb;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 建行数币红包发放
 * @author yangyukang
 * @date 2023/10/19
 */
@Data
public class CcbCountCoinsReq implements Serializable {

    private static final long serialVersionUID = -8284814424050518292L;

    /**
     * 活动编号id
     * 需向省行相关部门索取
     * 必填，最大长度50
     */
    @Size(max = 50, message = "ccbActId不能超过50")
    @NotBlank(message = "活动编号不能为空")
    private String ccbActId;

    /**
     * 手机号
     * 必选，最大长度64
     */
    @Size(max = 50, message = "phone不能超过50")
    @NotNull(message = "手机号不能为空")
    private String phone;

    /**
     * 不可大于活动最大金额
     */
    @NotNull(message = "活动金额不能为空")
    private Long amount;

    /**
     * 活动密钥
     * 需向省行相关部门索取
     */
    @NotBlank(message = "活动密钥不能为空")
    private String ccbAppKey;

}
