package cn.com.duiba.supplier.channel.service.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2023/12/27 17:53
 */
@Getter
@AllArgsConstructor
public enum BaWangCouponStatusEnum {
    SEND("未使用"),
    VERIFICATION("已使用"),
    ACTIVE_EXPIRE("已过期"),
    AUTO_EXPIRE("已回收"),
    ;
    private final String desc;
    
    private static final Map<String, BaWangCouponStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(Enum::name, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举名称获取枚举
     * @param name 枚举名称
     * @return 枚举
     */
    public static BaWangCouponStatusEnum getByName(String name) {
        if (name == null) {
            return null;
        }
        return ENUM_MAP.get(name);
    }
}
